package org.davic.mpeg.sections;

import org.openmhp.util.Out;

/**
* @author tejopa
* @date 12.2.2004
* @date 14.11.2004 checked, fully implemented
* @status fully implemented
* @module internal
*
*
This class is used to report when a TransportStream which was available becomes no longer available or if the section filter resources are removed from a connected SectionFilterGroup. In this second case, the notifyRelease() method of the ResourceClient will also be called in addition to this event being generated.
*/
public class ForcedDisconnectedEvent extends org.davic.resources.ResourceStatusEvent{

	/**
	*	This constructs a ForcedDisconnectedEvent
	*	for the specified SectionFilterGroup object.
	*/
	public ForcedDisconnectedEvent(SectionFilterGroup filter){
		super(filter);
		Out.printMe(Out.TRACE);
	}

	/**
    This returns the SectionFilterGroup object which filtered the data.

    Overrides:
        getSource in class ResourceStatusEvent

    Following copied from class: org.davic.resources.ResourceStatusEvent

    Returns:
        the object whose status changed

	*/
	public Object getSource(){
		Out.printMe(Out.TRACE);
		return super.getSource();
	}
}
