package org.dvb.event ;

//import java.util.*;
import java.awt.event.*;
import org.havi.ui.event.*;

import org.openmhp.util.*;


/**
* @author tejopa
* @date 5.3.2004
* @status fully implemented
* @module internal
*/
public class UserEventRepository extends RepositoryDescriptor {

    private String name;
	private LinkedList events;
	protected final static int[] ALLKEYS = new int[]{ KeyEvent.VK_UP, KeyEvent.VK_DOWN,KeyEvent.VK_LEFT,KeyEvent.VK_RIGHT,
				HRcEvent.VK_COLORED_KEY_0, HRcEvent.VK_COLORED_KEY_1, HRcEvent.VK_COLORED_KEY_2, HRcEvent.VK_COLORED_KEY_3,
				KeyEvent.VK_0, KeyEvent.VK_1, KeyEvent.VK_2, KeyEvent.VK_3, KeyEvent.VK_4, KeyEvent.VK_5, 
				KeyEvent.VK_6, KeyEvent.VK_7, KeyEvent.VK_8, KeyEvent.VK_9 };

    public UserEventRepository (String a_name) {
        Out.printMe(Out.TRACE);
        name = a_name;
        events = new LinkedList();
    }

    public void addAllArrowKeys(){
    	Out.printMe(Out.TRACE);
        addKeys(new int[]{KeyEvent.VK_UP,KeyEvent.VK_DOWN,KeyEvent.VK_LEFT,KeyEvent.VK_RIGHT});
    }

    public void addAllColourKeys(){
        Out.printMe(Out.TRACE);
        addKeys(new int[]{ HRcEvent.VK_COLORED_KEY_0, HRcEvent.VK_COLORED_KEY_1, HRcEvent.VK_COLORED_KEY_2, HRcEvent.VK_COLORED_KEY_3});
    }

    public void addAllNumericKeys() {
        Out.printMe(Out.TRACE);
        addKeys(new int[]{KeyEvent.VK_0, KeyEvent.VK_1, KeyEvent.VK_2, KeyEvent.VK_3, KeyEvent.VK_4, KeyEvent.VK_5, KeyEvent.VK_6, KeyEvent.VK_7, KeyEvent.VK_8, KeyEvent.VK_9});
    }

    public void addKey(int key){
        Out.printMe(Out.TRACE);
        addKeys(new int[]{ key} );
    }

    public void addUserEvent(UserEvent event) {
        for (int i=0;i<events.size();i++){
            UserEvent e = (UserEvent)events.get(i);
            if (e.getCode()==event.getCode()){
                return;
            }
        }
        events.add(event);
    }

    public UserEvent[] getUserEvent() {
        UserEvent[] result = new UserEvent[events.size()];
        for (int i=0;i<events.size();i++){
            result[i] = (UserEvent)events.get(i);
        }
        return result;
    }

    public void removeAllArrowKeys(){
        removeKeys(new int[]{KeyEvent.VK_UP,KeyEvent.VK_DOWN,KeyEvent.VK_LEFT,KeyEvent.VK_RIGHT});
    }

    public void removeAllColourKeys(){
        removeKeys(new int[]{HRcEvent.VK_COLORED_KEY_0, HRcEvent.VK_COLORED_KEY_1, HRcEvent.VK_COLORED_KEY_2, HRcEvent.VK_COLORED_KEY_3});
    }

    public void removeAllNumericKeys(){
        removeKeys(new int[]{KeyEvent.VK_0, KeyEvent.VK_1, KeyEvent.VK_2, KeyEvent.VK_3, KeyEvent.VK_4, KeyEvent.VK_5, KeyEvent.VK_6, KeyEvent.VK_7, KeyEvent.VK_8, KeyEvent.VK_9} );
    }

    public void removeUserEvent (UserEvent event) {
        events.remove(event);
    }

    public void removeKey(int key) {
        removeKeys(new int[]{ key });
    }

	protected void addKeys(int[] keys) {
		for (int i=0;i<keys.length;i++) {
			addUserEvent(new UserEvent(this, UserEvent.UEF_KEY_EVENT, KeyEvent.KEY_PRESSED, keys[i], -1));	
		}	
	}
	
	private void removeKeys(int[] keys) {
		for (int i=0;i<keys.length;i++) {
			for (int j=0;j<events.size();j++) {
				UserEvent e = (UserEvent)events.get(j);
				if (e.getCode()==keys[i]) {
					events.remove(e);	
				}
			}
		}
	}

}