package org.dvb.media;

import javax.media.StopEvent;
import javax.media.Controller;

/**
* @author tejopa
* @date 13.2.2004
* @date 7.3.2004
* @date 1.12.2004 docs
* @status fully implemented
* @module internal

Description
This event is generated whenever access to a service stops because the service concerned has been
removed from the network. Generation of this event informs the application that the Player is no longer
presenting any content.
Since:
MHP 1.0.1

*/
public class ServiceRemovedEvent extends StopEvent {

/*
public StopEvent(Controller from, int previous, int current, int target, Time mediaTime)
*/

	javax.media.MediaLocator currentStream;

	/**
	Construct an event.
	Parameters:
	source - the controller which was presenting the service
	*/
	public ServiceRemovedEvent(Controller obj){
		super(obj,0,0,0,null);
	}

	/**
	Construct an event.
	Parameters:
	source - the controller which was presenting the service
	stream - the locator of the stream which was removed from the network
	*/
	public ServiceRemovedEvent(Controller obj, javax.media.MediaLocator stream){
		super(obj,0,0,0,null);
		currentStream = stream;
	}

	/**
	This method returns the stream which was removed from the network
	Returns:
	the stream concerned
	*/
	public javax.media.MediaLocator getStream()	{
		return currentStream;
	}
}


