package org.dvb.si;

import java.util.Date;
import org.davic.net.dvb.DvbLocator;

/**
* @author tejopa
* @date 13.2.2004
* @status fully implemented
* @module internal
*/
public interface SIEvent extends SIInformation {

    public abstract DvbLocator getDvbLocator();

    public abstract int getOriginalNetworkID();

    public abstract int getTransportStreamID();

    public abstract int getServiceID();

    public abstract int getEventID();

    public abstract Date getStartTime();

    public abstract long getDuration();

    public abstract byte getRunningStatus();

    public abstract boolean getFreeCAMode();

    public abstract String getName();

    public abstract String getShortEventName();

    public abstract String getShortDescription();

    public abstract byte[] getLevel1ContentNibbles();

    public abstract byte[] getContentNibbles();

    public abstract SIRequest retrieveSIService(short word0, Object obj, SIRetrievalListener siretrievallistener, short aword0[]) throws SIIllegalArgumentException;

}