package org.dvb.si;

import java.util.Date;
import org.davic.net.dvb.DvbLocator;

/**
* @author tejopa
* @date 13.2.2004
* @status fully implemented
* @module internal
*/
public interface SIService extends SIInformation, TextualServiceIdentifierQuery {

    public abstract DvbLocator getDvbLocator();

    public abstract int getOriginalNetworkID();

    public abstract int getTransportStreamID();

    public abstract int getServiceID();

    public abstract short getSIServiceType();

    public abstract String getName();

    public abstract String getShortServiceName();

    public abstract String getProviderName();

    public abstract String getShortProviderName();

    public abstract boolean getEITScheduleFlag();

    public abstract boolean getEITPresentFollowingFlag();

    public abstract byte getRunningStatus();

    public abstract boolean getFreeCAMode();

    public abstract SIRequest retrievePresentSIEvent(short word0, Object obj, SIRetrievalListener siretrievallistener, short aword0[]) throws SIIllegalArgumentException;

    public abstract SIRequest retrieveFollowingSIEvent(short word0, Object obj, SIRetrievalListener siretrievallistener, short aword0[]) throws SIIllegalArgumentException;

    public abstract SIRequest retrieveScheduledSIEvents(short word0, Object obj, SIRetrievalListener siretrievallistener, short aword0[], Date date, Date date1) throws SIIllegalArgumentException, SIInvalidPeriodException;

    public abstract SIRequest retrievePMTService(short word0, Object obj, SIRetrievalListener siretrievallistener, short aword0[]) throws SIIllegalArgumentException;

    public abstract String[] getTextualServiceIdentifiers();

}