package org.havi.ui;

import java.awt.*;
import org.dvb.ui.TestOpacity;
import org.openmhp.util.Out;
import org.dvb.ui.*;
import java.awt.event.*;

/**
 * @author tejopa
 * @date 15.2.2004
 * @status partially implemented
 * @module internal, graphics
 * TODO: map double buffering etc adaptation layer
 * TODO opaque etc
 * @priority high
 */
public abstract class HComponent extends Component implements KeyListener, HMatteLayer, TestOpacity {
    
    private Color backgroundColor;
    
    private HMatte hMatte;
    private boolean enabled;
    
    public HComponent() {
        enabled = true;
        Out.printMe(Out.TRACE,"done");
    }
    
    public HComponent(int x, int y, int width, int height) {
        setBounds(x, y, width, height);
        Out.printMe(Out.TRACE,"done "+x+","+y+" "+width+"x"+height);
    }
    
    public void setBackground(Color c) {
        Out.printMe(Out.TRACE,""+c.toString());
        backgroundColor = c;
    }
    
    public Color getBackground() {
        return backgroundColor;
    }
    
    
    public void paint(Graphics g) {
        
        Out.printMe(Out.TRACE);
        g.setColor(backgroundColor);
        if (backgroundColor != null) {
            System.out.println("Filling with "+backgroundColor.toString());
            g.fillRect(0, 0, getWidth(), getHeight());
        }
        
        super.paint((DVBGraphics)g);
    }
    
    
    public void setMatte(HMatte hmatte) throws HMatteException {
        Out.printMe(Out.TRACE);
        hMatte = hmatte;
    }
    
    public HMatte getMatte() {
        Out.printMe(Out.TRACE);
        return hMatte;
    }
    
    public boolean isDoubleBuffered() {
        Out.printMe(Out.TODO);
        return false;
    }
    
    public boolean isOpaque() {
        Out.printMe(Out.TODO);
        return false;
    }
    
    public void setEnabled(boolean b) {
        Out.printMe(Out.TRACE);
        enabled = b;
    }
    
    public boolean isEnabled() {
        Out.printMe(Out.TRACE,enabled+" | "+this.toString());
        return enabled;
    }
    
    /**
     * FIXME: create support for org.havi.ui.events 28.4.2004, tejopa
     */
    protected void processEvent(AWTEvent awtevent) {
        Out.printMe(Out.TRACE);
        super.processEvent(awtevent);
    }
    
    // KeyListener tejopa 1.2.2005
    
    public void keyPressed(KeyEvent e) { }
    public void keyTyped(KeyEvent e) { }
    public void keyReleased(KeyEvent e) { }
    
}
