package org.havi.ui;

import java.awt.Dimension;

/**
* @author tejopa
* @date 6.3.2004
* @status fully implemented
* @module internal
* TODO Check LARGEST_PIXEL_DIMENSION
*/
public class HSceneTemplate{

	public static final int REQUIRED                = 0x01;
    public static final int PREFERRED               = 0x02;
    public static final int UNNECESSARY             = 0x03;

    public static final int GRAPHICS_CONFIGURATION  = 0x00;
    public static final int SCENE_PIXEL_DIMENSION   = 0x01;
    public static final int SCENE_PIXEL_LOCATION    = 0x02;
    public static final int SCENE_SCREEN_DIMENSION  = 0x04;
    public static final int SCENE_SCREEN_LOCATION   = 0x08;

    public static final Dimension LARGEST_PIXEL_DIMENSION = new Dimension(720, 576);

    private Object[] objects;
    private int[] priorities;

    public HSceneTemplate(){
		objects 	= new Object[9];
		priorities 	= new int[9];
		for (int i=0;i<priorities.length;i++) {
			priorities[i] = UNNECESSARY;
		}
	}

    public void setPreference(int preference, Object object, int priority){
		objects[preference] = object;
		priorities[preference] = priority;
	}

    public Object getPreferenceObject(int preference){
        return objects[preference];
    }

    public int getPreferencePriority(int preference){
        return priorities[preference];
    }
}




