package org.havi.ui;

import java.awt.*;
import org.openmhp.util.*;

/* HOME */
/**
* @author tejopa
* @date 7.3.2004
* @status partially implemented
* @module internal
*/
// TODO showLook
public class HTextLook implements HLook{

	private Insets currentInsets = new Insets(0, 0, 0, 0);

    public HTextLook(){
    	Out.printMe(Out.TRACE);	
    }

    public Insets getInsets(HVisible hVisible){
        return currentInsets;
    }

    public Dimension getMaximumSize(HVisible hvisible){
        // HLook must support content scaling
        return hvisible.getMaximumSize();
    }

    public Dimension getMinimumSize(HVisible hvisible){
        return hvisible.getMinimumSize();
    }

    public Dimension getPreferredSize(HVisible hvisible){
		// If data for dimension calculations is not available, simply return the size of the hVisible.
        return hvisible.getSize();
    }

    public boolean isOpaque(HVisible hvisible){
        return hvisible.isOpaque();
    }

    public void showLook(Graphics g, HVisible hvisible, int state){
        Dimension d = hvisible.getSize();
        if (hvisible.getBackgroundMode()==HVisible.BACKGROUND_FILL){
            Color c = hvisible.getBackground();
            if(c!=null){
				g.setColor(c);
				g.fillRect(0, 0, d.width, d.height);
            	if (hvisible instanceof HTextButton) {
	            	if (((HTextButton)hvisible).isSelected()) {
						g.setColor(hvisible.getForeground());
						g.drawRect(0, 0, d.width-1, d.height-1);
	            	}
	            }
            }
        }
        String text = (String)hvisible.getTextContent(state);
        if(text!=null){
            hvisible.getTextLayoutManager().render(text, g, hvisible, currentInsets);
        }
    }

    public void widgetChanged(HVisible hVisible, HChangeData ahchangedata[]){
		//A minimum implementation of this method could simply call visible.repaint()
        hVisible.repaint();
    }

}
