package org.openmhp.application;

import org.dvb.application.*;
import org.openmhp.xlet.*;
import org.openmhp.system.*;
import javax.tv.xlet.*;
import java.net.*;
import java.util.*;
import java.io.*;

/** tejopa */
public class AppProxyImpl implements AppProxy, Serializable {

	public static final int DESTROYED = 1;
	public static final int NOT_LOADED = 2;
	public static final int PAUSED = 3;
	public static final int STARTED = 4;


	private AppAttributesImpl appAttributes;
	private XletLoader loader;
	private int state = NOT_LOADED;
	private int oldState = NOT_LOADED;
	private  Xlet xlet;
	private  Class loadedClass;
	public Vector appStateChangeEventListenerVec;
	
	boolean classloader;

	public AppProxyImpl(AppAttributesImpl appimpl) {
		appAttributes = appimpl;
		//initialClass = appAttributes.getInitialClass();
		//classpath = appAttributes.getClasspath();
		appStateChangeEventListenerVec = new Vector();
	}

	public AppAttributesImpl getAttributes() {
		return appAttributes;
	}

	public AppID getIdentifier() {
		return appAttributes.getIdentifier();
	}

	public void addAppStateChangeEventListener(AppStateChangeEventListener listener) {
		appStateChangeEventListenerVec.add(listener);
	}

	public void removeAppStateChangeEventListener(AppStateChangeEventListener listener) {
		appStateChangeEventListenerVec.remove(listener);
	}

	public int getState() {
		return state;
	}

	public int getOldState() {
		return oldState;
	}

	public void setState(int newState) {
		oldState = state;
		state = newState;
		stateChange(oldState,state);
	}

	public void pause() {
		pauseXlet();
		setState(PAUSED);
	}

	public void resume() {
		startXlet();
		setState(STARTED);
	}

	public String getClasspath() {
		return appAttributes.getClasspath();
	}

	public String getInitialClass() {
		return appAttributes.getInitialClass();
	}

	public void start() {
		loadXlet(getClasspath(),getInitialClass());
		initXlet();
		pause();
		start(null);
	}

	public void start(java.lang.String[] args) {
		startXlet();
		setState(STARTED);
	}

	public void stop(boolean forced) {
		//if (forced) {
		//	loader = null;
		//}
		//else {
		setState(DESTROYED);
		destroyXlet(forced);
		//}

	}

	/**
	Method starts loading xlet
	@author tejopa
	@version 20.4.2003
	*/
	 void loadXlet(String xletPath, String xletName) {
		URL url = null;
		try { url = new URL(xletPath); }
		catch (Exception e) { System.out.println(e); }

		loader = new XletLoader(new URL[]{ url });
		try {
 			loadedClass = loader.loadClass(xletName);
		}
		catch (Exception e) { System.out.println(e); }
		try		{
			xlet = (Xlet)loadedClass.newInstance();
		}
		catch (Exception e)		{
			System.out.println(e.toString());
		}
	}


	/**
	Method calls current xlet's initXlet() method
	@author tejopa
	@version 20.4.2003
	*/
	 void initXlet() {
		//FrameXletContext context = new FrameXletContext();
		//context.setRun(this);
		try	{
			xlet.initXlet(new XletContextImpl(null,xlet));
		}
		catch(Exception e) {
			return;
        }
	}

	/**
	Method calls current xlet's startXlet() method
	@author tejopa
	@version 20.4.2003
	*/
	 void startXlet()	{
		try	{
			xlet.startXlet();
		}
		catch(Exception e) {
			return;
        }
	}

	/**
	Method calls current xlet's pauseXlet() method
	@author tejopa
	@version 18.1.2002
	*/
	 void pauseXlet()	{
		try	{
			xlet.pauseXlet();
		}
		catch(Exception e) {
			return;
        }
	}

	/**
	Method calls current xlet's pauseXlet() method
	@author tejopa
	@version 18.1.2002
	*/
	 void destroyXlet(boolean value)	{
		try	{
			xlet.destroyXlet(value);
		}
		catch(Exception e) {
			return;
        }
	}

	private void stateChange(int from, int to) {
		Enumeration e = appStateChangeEventListenerVec.elements();
		AppStateChangeEvent event = new AppStateChangeEvent(getIdentifier(),from,to,this,false);
		while (e.hasMoreElements()) {
			AppStateChangeEventListener listener = (AppStateChangeEventListener)e.nextElement();
			System.out.println("Listener: "+listener.toString()+" was sent message");
			listener.stateChange(event);
		}
	}

}