package org.openmhp.application;


import org.dvb.application.*;
import java.io.Serializable;

public class SerializedAppdata implements Serializable {

	private int AID = 0;
	private int OID = 0;
	private int state = 0;
	private int oldstate = 0;
	private String initialClass;
	private String classpath;
	private String name;
	private boolean classloader;

	public SerializedAppdata(AppProxyImpl app) {
		state = app.getState();
		oldstate = app.getOldState();
		AID = app.getIdentifier().getAID();
		OID = app.getIdentifier().getOID();
		initialClass = app.getInitialClass();
		classpath = app.getClasspath();
		name = app.getAttributes().getName();
		classloader = app.getAttributes().getClassloader();
		//System.out.println(">>>> "+initialClass+" "+classpath+" "+name);
	}

	public int getState() { return state; }
	public int getOldState() { return oldstate; }
	public int getAID() { return AID; }
	public int getOID() { return OID; }
	public String getInitialClass() { return initialClass; }
	public String getClasspath() { return classpath; }
	public String getName() { return name; }	
	public boolean getClassloader() { return classloader; }
}