package org.openmhp.appman;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;

import org.openmhp.util.*;
import org.openmhp.system.*;

/**
 * This class can be used to add configurable functions to the OpenMHP
 * environment.
 *
 * @author tejopa
 * @date 29.9.2004 Added Iframe conversion program selection
 * @date 10.12.2004 Added jar file configurations
 */
public class Configuration extends JFrame implements ActionListener, MouseListener {
    
    private JTabbedPane tabbedPane;
    
    private JPanel currentTab;
    
    private JPopupMenu popupmenu;
    private JMenuItem add;
    private JMenuItem start;
    private JMenuItem remove;
    
    
    private JTextField iframedir;
    
    private JTextField javatv_jar;
    private JTextField jmf_jar;
    
    JCheckBox usecheckbox;
    JTextField classpath;
    
    private JMenuBar menuBar;
    private JMenu fileMenu;
    
    
    public Configuration() {
        main();
    }
    
    private void main() {
        
        menuBar = new JMenuBar();
        
        fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        
        JMenuItem close = new JMenuItem("Close");
        close.addActionListener(this);
        close.setActionCommand("close");
        fileMenu.add(close);
        
        
        setJMenuBar(menuBar);
        
        setTitle("Configuration window");
        setSize(500, 400);
        setVisible(true);
        setLocation(getX()+20,getY()+20);
        
        // create tabbed pane
        tabbedPane = new JTabbedPane();
        getContentPane().add(tabbedPane);
        
        
        // add iframe-tab
        JPanel iframeConfig = new JPanel();
        tabbedPane.add("IFrames",iframeConfig);
        
        JTextArea infotext = new JTextArea();
        infotext.setText(""
                +"Select the directory that contains  Imagemagick's program 'convert'"
                +" or 'convert.exe'. \n"
                +"If you don't have Imagemagick installed, leave the line blank.");
        infotext.setEditable(false);
        infotext.setBackground(new Color(204,204,204));
        iframeConfig.add(infotext);
        
        Box yline = new Box(BoxLayout.Y_AXIS);
        
        Box line = new Box(BoxLayout.X_AXIS);
        iframedir = new JTextField(30);
        
        String FS = File.separator;
        //Properties p = loadProperties(System.getProperty("base_dir")+"static"+FS+"openmhp.properties");
        iframedir.setText(System.getProperty("iframe_convert",""));
        
        JButton browsedir = new JButton("Browse");
        browsedir.addActionListener(this);
        browsedir.setActionCommand("iframe");
        line.add(iframedir);
        line.add(browsedir);
        iframeConfig.add(line);
        
        
        yline.add(line);
        yline.add(new Box.Filler(new Dimension(0,25), new Dimension(170,25), new Dimension(getWidth(),25)));
        
        
        iframeConfig.add(yline);
        
        JTextArea infotext2 = new JTextArea();
        infotext2.setText(""
                +"If you don't have Iframe-conversion program, you can display the default image \n"
                +"in the background, or use your own image. Choose option 'use images' to\n"
                +"display your own background image in JPG-, GIF- or PNG-format.\n"
                +"NOTE: You cant use MPEG2-I-frames as a background without conversion program.\n");
        infotext2.setEditable(false);
        infotext2.setBackground(new Color(204,204,204));
        iframeConfig.add(infotext2);
        
        
        Box line3 = new Box(BoxLayout.X_AXIS);
        //JLabel useimages = new JLabel("");
        //line3.add(useimages);
        String us = System.getProperty("use_background_image","false");
        boolean useimages = false;
        if (us.indexOf("true")!=-1) useimages = true;
        
        usecheckbox = new JCheckBox("Use own background images (JPG, GIF, PNG)",useimages);
        line3.add(usecheckbox);
        
        iframeConfig.add(line3);
        
        
        Box line2 = new Box(BoxLayout.X_AXIS);
        JButton saveb = new JButton("Save");
        saveb.addActionListener(this);
        saveb.setActionCommand("save");
        line2.add(new Box.Filler(new Dimension(0,25), new Dimension(340,25), new Dimension(getWidth(),25)));
        line2.add(saveb);
        
        iframeConfig.add(line2);
        
        
        
        // CLASSPATH
        
        JPanel classpathConfig = new JPanel();
        tabbedPane.add("Classpath",classpathConfig);
        
        JTextArea infotext3 = new JTextArea();
        infotext3.setText(""
                +"Usually you should put all your files to the same application directory.\n"
                +"But if for some reason you have to use additional classpaths, you can set\n"
                +"them here. This line is added to the classpath of the (each) launched xlet.");
        infotext3.setEditable(false);
        infotext3.setBackground(new Color(204,204,204));
        classpathConfig.add(infotext3);
        
        String c = System.getProperty("additional_classpath","");
        classpath = new JTextField(c,40);
        classpathConfig.add(classpath);
        
        Box line4 = new Box(BoxLayout.X_AXIS);
        JButton saveb2 = new JButton("Save");
        saveb2.addActionListener(this);
        saveb2.setActionCommand("save");
        line4.add(new Box.Filler(new Dimension(0,25), new Dimension(340,25), new Dimension(getWidth(),25)));
        line4.add(saveb2);
        
        classpathConfig.add(line4);
        
        
        // JARS
        JPanel jarConfig = new JPanel();
        tabbedPane.add("Jars",jarConfig);
        
        Box tvline = new Box(BoxLayout.X_AXIS);
        javatv_jar = new JTextField(25);
        
        Box jmfline = new Box(BoxLayout.X_AXIS);
        jmf_jar = new JTextField(25);
        
        javatv_jar.setText(System.getProperty("javatv_jar",""));
        jmf_jar.setText(System.getProperty("jmf_jar",""));
        
        JButton browsejavatvdir = new JButton("Browse");
        browsejavatvdir.addActionListener(this);
        browsejavatvdir.setActionCommand("javatv_jar");
        JLabel javatvlabel = new JLabel("JavaTV.jar path: ");
        tvline.add(javatvlabel);
        tvline.add(javatv_jar);
        tvline.add(browsejavatvdir);
        jarConfig.add(tvline);
        
        
        JButton browsejmfdir = new JButton("Browse");
        browsejmfdir.addActionListener(this);
        browsejmfdir.setActionCommand("jmf_jar");
        JLabel jmflabel = new JLabel("jmf.jar path: ");
        jmfline.add(jmflabel);
        jmfline.add(jmf_jar);
        jmfline.add(browsejmfdir);
        jarConfig.add(jmfline);
        
        
        Box line5 = new Box(BoxLayout.X_AXIS);
        JButton jarsave = new JButton("Save");
        jarsave.addActionListener(this);
        jarsave.setActionCommand("save");
        line5.add(new Box.Filler(new Dimension(0,25), new Dimension(340,25), new Dimension(getWidth(),25)));
        line5.add(jarsave);
        
        
        jarConfig.add(line5);
        
        
        validate();
        
    }
    
    /* 10.12.2004 tejopa*/
    public void  setSelectedIndex(int i) {
        tabbedPane.setSelectedIndex(i);
    }
    
    public void actionPerformed(ActionEvent event)   {
        String cmd = event.getActionCommand();
        if (cmd=="close") { setVisible(false); return; }
        if (cmd=="iframe") {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
            try {
                fc.setCurrentDirectory(new File(""));
            } catch (Exception e) { }
            int returnVal = fc.showOpenDialog(this);
            File file = fc.getSelectedFile();
            if (file!=null) {
                try {
                    String filename = file.getAbsolutePath();
                    iframedir.setText(filename);
                } catch (Exception e) {
                    System.out.println(e);
                }
            }
            return;
        }
        if (cmd=="javatv_jar") {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
            try {
                fc.setCurrentDirectory(new File(""));
            } catch (Exception e) { }
            int returnVal = fc.showOpenDialog(this);
            File file = fc.getSelectedFile();
            if (file!=null) {
                try {
                    String filename = file.getAbsolutePath();
                    javatv_jar.setText(filename);
                } catch (Exception e) {
                    System.out.println(e);
                }
            }
            return;
        }
        if (cmd=="jmf_jar") {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
            try {
                fc.setCurrentDirectory(new File(""));
            } catch (Exception e) { }
            int returnVal = fc.showOpenDialog(this);
            File file = fc.getSelectedFile();
            if (file!=null) {
                try {
                    String filename = file.getAbsolutePath();
                    jmf_jar.setText(filename);
                } catch (Exception e) {
                    System.out.println(e);
                }
            }
            return;
        }
        if (cmd=="save") {
            try {
                String FS = File.separator;
                Properties p = loadProperties(System.getProperty("base_dir")+FS+"static"+FS+"openmhp.properties");
                p.setProperty("iframe_convert",iframedir.getText());
                p.setProperty("use_background_image",new Boolean(usecheckbox.isSelected()).toString());
                p.setProperty("additional_classpath",classpath.getText());
                p.setProperty("javatv_jar",javatv_jar.getText());
                p.setProperty("jmf_jar",jmf_jar.getText());
                
                saveProperties(System.getProperty("base_dir")+FS+"static"+FS+"openmhp.properties",p);
                setVisible(false);
            } catch (Exception e) { Out.printMe(Out.ERROR,e.toString()); }
            return;
        }
        
    }
    
    
    public void mouseClicked(MouseEvent e) {
        int clicks = e.getClickCount();
        if (clicks==2) {
            
        }
        if (e.getButton()==MouseEvent.BUTTON3) {
            //popupmenu.show(applicationList, e.getX(), e.getY());
            
        }
    }
    
    public void mouseEntered(MouseEvent e) { }
    public void mouseExited(MouseEvent e) { }
    public void mousePressed(MouseEvent e) { }
    public void mouseReleased(MouseEvent e) { }
    
    class ClassFilter extends javax.swing.filechooser.FileFilter {
        
        public ClassFilter() { }
        
        public boolean accept(File f) {
            if (f.getName().indexOf(".class")!=-1) {
                return true;
            }
            if (f.isDirectory()) {
                return true;
            } else {
                return false;
            }
        }
        
        public String getDescription() {
            return "Java class files";
        }
        
    }
    
    public static Properties loadProperties(String filename) {
        Properties p = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            try {	p.load(fis);	} catch (IOException e) {
                System.out.println(e.toString());
            }
        } catch (Exception e) {
            Out.printMe(Out.ERROR,"Error while loading properties file >"+filename+"< "+e.toString());
        }
        //System.out.println("Properties file >"+filename+"< loaded.");
        return p;
    }
    
    public static void saveProperties(String filename, Properties props) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
            try {	props.store(fos,null);	} catch (IOException e) {
                System.out.println(e.toString());
            }
        } catch (Exception e) {
            System.out.println("Error while saving properties file >"+filename+"< "+e.toString());
        }
        System.out.println("Properties file >"+filename+"< saved.");
    }
    
}
