package org.openmhp.system;

import java.awt.*;
import javax.swing.*;
import org.havi.ui.*;

import org.openmhp.util.*;

import java.io.*;
import java.net.*;
import org.openmhp.adaptation.graphics.*;
import java.awt.image.*;

/**
* This class presents a MHPDevice. Currently there are no
* different configurations available.
*/
public class MHPDevice extends Container implements Runnable{

	/* Container for graphics layers */
	static Container[] layers;

	/* Instance */
	static MHPDevice instance;

	/* Layers */
	private static final int EXTRA_LAYER = 0;
	private static final int SUBTITLE_LAYER = 1;
	private static final int GRAPHICS_LAYER = 2;
	private static final int VIDEO_LAYER = 3;
	private static final int BACKGROUND_LAYER = 4;

	static Container EXTRA_LAYER_C ;
	static SubtitleLayer SUBTITLE_LAYER_C ;
	static GraphicsLayer GRAPHICS_LAYER_C ;
	static VideoLayer VIDEO_LAYER_C ;
	static Container BACKGROUND_LAYER_C ;

	/** Aspect ratio */
	private static final int NORMAL = 0;
	private static final int WIDESCREEN = 1;

	/** Hscene */
	HScene hscene;

	Thread updater;

	/** Creation */
	protected MHPDevice()  {
		super();
		
		Out.printMe(Out.TRACE);
		
		setSize(720,576);
		setName(getClass().toString());
		//setLayout(null);
		setLayout(new BorderLayout());
		
		String FS = java.io.File.separator;

		EXTRA_LAYER_C = new ExtraLayer();
		SUBTITLE_LAYER_C = SubtitleLayer.getInstance();
		SUBTITLE_LAYER_C.setSubtitles(org.openmhp.system.Constants.ROOT+FS+"mhp"+FS+"static"+FS+"fin.srt");
		
		GRAPHICS_LAYER_C = new GraphicsLayer();
		VIDEO_LAYER_C = VideoLayer.getInstance();
		BACKGROUND_LAYER_C = new BackgroundLayer();

		hscene = HSceneFactory.getInstance().getBestScene(null);
		
		GRAPHICS_LAYER_C.add(hscene);

		add("Center",EXTRA_LAYER_C);
		add("Center",SUBTITLE_LAYER_C);
		add("Center",GRAPHICS_LAYER_C);		
		add("Center",VIDEO_LAYER_C);
		add("Center",BACKGROUND_LAYER_C);

		VIDEO_LAYER_C.setBackgroundImage(org.openmhp.system.Constants.ROOT+java.io.File.separator+org.openmhp.system.Constants.STILL_IMAGE);
		//VIDEO_LAYER_C.setBackgroundVideo("c:/tausta.mpeg");		


		VIDEO_LAYER_C.setMode(VideoLayer.STILL_IMAGE);
		VIDEO_LAYER_C.start();
		
//		list(System.out,5);
	
	
		//updater = new Thread(this);
		//updater.start();
		
		
		// EIT PARSER 
		// ----------
		//EITParser eitParser = EITParser.getInstance("c:/java/EIT_nelonen.txt");
		//eitParser.start();
	
		bi = new BufferedImage(720,576,BufferedImage.TYPE_INT_RGB);
		
	}

	public static Container getExtraLayer() { return EXTRA_LAYER_C;	}

	public static Container getSubtitleLayer() { return SUBTITLE_LAYER_C; 	}

	public static GraphicsLayer getGraphicsLayer() { return GRAPHICS_LAYER_C;	}

	public static VideoLayer getVideoLayer() { return VIDEO_LAYER_C;	}

	public static Container getBackgroundLayer() { return BACKGROUND_LAYER_C;	}

	/** Get instance of MHPDevice */
	public static MHPDevice getInstance() {
		if (instance==null) {
			instance = new MHPDevice();
		}
		return instance;
	}

/*
	public void paint(Graphics g) {
		paintComponents(bi.getGraphics());	
		sendImage(bi);
	}
*/

	public Graphics getGraphics() {
		System.out.println("KN JFOJD FNDJFN ");
		return super.getGraphics();
	}

	public void run() {
	
		while (true) {
			try {
				updater.sleep(2000);
				EventQueue ls =Toolkit.getDefaultToolkit().getSystemEventQueue();
				System.out.println(ls.peekEvent().toString());
			}	
			catch (Exception e) { }
			repaint();
		}	
	}

	boolean sending = false;

	private void sendImage(BufferedImage bufferedImage) {
	long start = System.currentTimeMillis();
//	if (bi==null) {
//			bi = new BufferedImage(720,576,BufferedImage.TYPE_INT_RGB);
//		}
//		Graphics big = bi.getGraphics();
//		paintComponents(big);
	
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		
		try {
			javax.imageio.ImageIO.write(bi, "JPEG", baos );
		}
		catch (Exception e) {
			System.out.println(e);	
		}
	/*
		if (ti==null) {
			ti = new TransferImage(new byte[0]);
		}
	*/
		if (s == null) {
			try {
				s = new Socket("127.0.0.1",51234);
				oos = new ObjectOutputStream(s.getOutputStream());
			}
			catch (Exception e) {
				System.out.println(e);	
			}
		}
		if (oos!=null) {
			try {
				System.out.println("Sending...");
				//ti.setData(baos.toByteArray());
				oos.writeObject(new TransferImage(baos.toByteArray()));
				System.out.println("Sent");
			}
			catch (Exception e) { 
				System.out.println(e);
			}	
		}
		long end = System.currentTimeMillis();
	
		System.out.println("JPEG sending took: "+(end-start)+" ms.");
	
	}

	ObjectOutputStream oos;
	Socket s;
	TransferImage ti;
	BufferedImage bi;
	
}