package org.openmhp.system;

import java.io.*;
import java.util.StringTokenizer;
import org.openmhp.util.LinkedList;
import org.openmhp.util.Out;

/**
* This class parses srt formatted subtitle files
*
* @author tejopa
* @date 12.3.2004
* TODO move behind adapatation layer
*/
public class SrtSubs {
	
	private LinkedList subtitles;
	private int index = 0;
	private final Subtitle EMPTY = new Subtitle(-1, new String[]{ "" }, 0, 0); 
	
	public SrtSubs(String filename) {
		subtitles = new LinkedList();	
		createSubs(filename);
	}

	private void createSubs(String filename) {
		LinkedList lines = new LinkedList();
		try {
			File cf = new File(filename);
			if (cf.exists()) {
				BufferedReader br = new BufferedReader(new FileReader(cf));
				String line = "";
				try {
					while ( (line = br.readLine()) != "") {
						lines.add(line.trim());	
					}
				}
				catch (Exception e) { 
					//System.out.println("loading allowed classes: "+e.toString());
				}
			}
			else {
				System.out.println("srt file not found!");
			}
		}
		catch (Exception e) {
			Out.error(this,e.toString());	
		}
		
		int i = 0;
		int number = 1;
		String findthis = ""+number;		
		// find text number 
		while (i<lines.size()) {
			while (i<lines.size()&&!((String)lines.get(i)).equals(findthis)) {
				i++;
			}
			if (i>=lines.size()) { break; }
						
			i++;
			String times = (String)lines.get(i);
			i++;
			LinkedList ss = new LinkedList();
			while (i<lines.size()&&!((String)lines.get(i)).trim().equals("")) {
				ss.add((String)lines.get(i));
				i++;
			}
			String[] l = new String[ss.size()];
			for (int j=0;j<l.length;j++) {
				l[j] = (String)ss.get(j);	
			}
			
			String starttime = times.substring(0,12);
			String endtime = times.substring(times.length()-12,times.length());
			StringTokenizer t = new StringTokenizer(starttime);
			int shours = new Integer(t.nextToken(":")).intValue();
			int sminutes = new Integer(t.nextToken(":")).intValue();
			String temp = t.nextToken(":");
			int sseconds = new Integer(temp.substring(0,temp.indexOf(','))).intValue();
			int smillis = new Integer(temp.substring(temp.indexOf(',')+1,temp.length())).intValue();
			
			StringTokenizer ts = new StringTokenizer(endtime);
			int ehours = new Integer(ts.nextToken(":")).intValue();
			int eminutes = new Integer(ts.nextToken(":")).intValue();
			temp = ts.nextToken(":");
			int eseconds = new Integer(temp.substring(0,temp.indexOf(','))).intValue();
			int emillis = new Integer(temp.substring(temp.indexOf(',')+1,temp.length())).intValue();
			


			subtitles.add(new Subtitle(number,l,shours*60*60*1000+sminutes*60*1000+sseconds*1000+smillis,ehours*60*60*1000+eminutes*60*1000+eseconds*1000+emillis));
			
		//	System.out.println(((Subtitle)subtitles.getLast()).toString());
			
			number++;
			findthis = ""+number;
		}
				
	}
		
	public Subtitle next() {
		if (index<subtitles.size()) {
			Subtitle result = (Subtitle)subtitles.get(index);	
			index++;
			return result;
		}
		else {
			return EMPTY;	
		}
	}
	
	public class Subtitle {
		
		int index = -1;
		String[] lines;
		long start;
		long end;
		
		public Subtitle(int i, String[] l, long s, long e) {
			index = i;
			lines = l;
			start = s;
			end = e;	
		}
			
		public String toString() {
			String result = " index: "+index;
			for (int i=0;i<lines.length;i++) {
				result+=" "+lines[i];
			}
			result+=" start: "+start+" end: "+end;	
			return result;
		}
		
		public String[] getLines() { return lines; }
	}
	
}