package org.openmhp.system;

import org.openmhp.util.Out;

import java.io.*;
import javax.swing.*;
import javax.media.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;

/**
*
* Player for video files.
*
*
* @author tejopa
* @date 10.5.2004
* @status fully implemented
* @module internal
*/
public class VideoPlayer extends AnyPlayer implements ControllerListener {

	Player player = null;
	Thread update;
	boolean realized = false;

    public VideoPlayer(String s) {
    	super();
    	init(new File(s));
    	
        //visualComponent = new StillImage(s);
    }

    public void start()    {
		if (visualComponent!=null) {
			visualComponent.setSize(720,576);
			visualComponent.setLocation(0,-20);
			visualComponent.setVisible(true);
    	    isStarted = true;
			player.start();
    	 }
    	 else {
    	 	Out.printMe(Out.ERROR,"NO VIDEO COMPONENT AVAILABLE");
    	 }
    }

    public void stop()    {
        visualComponent.setVisible(false);
        isStarted = false;
    }


	public void init(File file) {
		String mediafile = "";
		if (file!=null) {
			try {
				mediafile = file.getAbsolutePath();
				//controls.setFile(mediafile);
				System.out.println(mediafile);
			}
			catch (Exception e) {
				System.out.println(e);
			}
		}
		else {
			return;
		}

		if (player!=null) {
			player.stop();
		}
		player = null;
		realized = false;
		try {
			
			//Manager.setHint(Manager.LIGHTWEIGHT_RENDERER, new Boolean(true));	
			
			player = Manager.createPlayer(new URL("file:\\\\\\"+mediafile));
			player.addControllerListener(this);
		}
		catch (Exception e) {
			//JOptionPane.showMessageDialog(this,e);
			Out.printMe(Out.ERROR,"While creating player: "+e);
			return;
			//System.out.println("While creating player: "+e);
		}
		player.addControllerListener(this);

		printState(player);
		try {
			player.prefetch();
			player.realize();

		}
		catch (Exception e) {
			Out.printMe(Out.ERROR,"While creating player: "+e);
			//JOptionPane.showMessageDialog(this,e);
		}

		while (!realized) {
			try {
				Thread.currentThread().sleep(500);
			}
			catch (Exception e) { }
			Out.printMe(Out.TRACE,"waiting for realization...");
		}


		Component c = null;
		try {
			c = player.getVisualComponent();
		}
		catch (Exception e) {
			Out.printMe(Out.ERROR,"While creating player: "+e);
//			JOptionPane.showMessageDialog(this,e);
			//System.out.println("while getting the visual component: "+e);
		}
		if (c!=null) {
			visualComponent = c;
			//videoWindow.setVisualComponent(c);
			//videoWindow.pack();
		}
		else {
			//videoWindow.noVideo();
			//videoWindow.pack();
		}
		//arrange();
	}

	/** Notices when file ends */
	public void controllerUpdate(ControllerEvent event) {
		if (event instanceof javax.media.EndOfMediaEvent) {
		//	playlist.playNext();
		}
		if (event instanceof javax.media.RealizeCompleteEvent) {
			realized = true;
			System.out.println("Realized!");
		}
	}

	private void printState(Player p) {
		switch (p.getState()) {
			case Controller.Prefetched:	System.out.println("Prefetched");
			case Controller.Prefetching: System.out.println("Prefetching");
			case Controller.Realized: System.out.println("Realized");
			case Controller.Started: System.out.println("Started");
			case Controller.Unrealized: System.out.println("Unrealized");

		}
	}

}