package org.openmhp.system;

import java.util.Properties;
import java.io.*;

/**
* This class represents the Xlet available for execution. The class
* contains the essential data for launching this xlet. Instances of
* this class are used in this MPH RE implementation. User can add it's own
* xlets to the system with it and it is also used for data source for
* implementation of class org.dvb.application.AppsDatabase.
*
* @author tejopa
* @date 14.11.2003
*/
public class XletProps{

    private String xletName;
    private String xletPath;
    private String initialClass;
    private String backgroundFile;
	private int orgId;
	private int appId;

	/** Create properties from arguments */
    public XletProps(String s, String s1, String s2, String s3, int a, int o) {
		xletName = s;
		xletPath = s1;
		initialClass = s2;
		backgroundFile = s3;
		appId = a;
		orgId = o;
    }

	/** Load properties from file */
	public XletProps(String filename) {
		Properties p = loadProperties(filename);
		xletName = p.getProperty("xletName","Unknown");
		xletPath = p.getProperty("xletPath","Unknown");
		initialClass = p.getProperty("initialClass","Unknown");
		backgroundFile = p.getProperty("backgroundFile","Unknown");
		appId = Integer.valueOf(p.getProperty("orgId","-1")).intValue();
		orgId = Integer.valueOf(p.getProperty("appId","-1")).intValue();
	}

	public int getAppId() { return appId; }

	public int getOrgId() { return orgId; }

    public String getBackgroundFile() { return backgroundFile;}

    public String getInitialClass() { return initialClass; }

    public String getXletPath() { return xletPath; }

    public String getXletName() { return xletName; }

	/** Load properties from file */
	public Properties loadProperties(String filename) {
		Properties p = new Properties();
		FileInputStream fis = null;
		try {
			fis = new FileInputStream(filename);
			try {	p.load(fis);	}
			catch (IOException e) {
				System.out.println(e.toString());
				}
			}
		catch (Exception e) {
			System.out.println("Error while loading properties file >"+filename+"< "+e.toString());
			}
		return p;
	}

}