import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;

/**
* This class can be used to configure ant build.properties
*
* @author tejopa
* @date 5.4.2005
*/
public class Configure extends JFrame implements ActionListener, MouseListener {

	private JTabbedPane tabbedPane;

	private JPanel currentTab;

	private JPopupMenu popupmenu;
	private JMenuItem add;
	private JMenuItem start;
	private JMenuItem remove;


	private JTextField iframedir;

	private JTextField javatv_jar;
	private JTextField jmf_jar;
	private JTextField java;

	JCheckBox usecheckbox;
	JTextField classpath;

	private JMenuBar menuBar;
	private JMenu fileMenu;


	String base_dir;

	Properties props;

	public static void main(String[] args) {
		new Configure(args[0]);
	}

	public Configure(String root) {
		base_dir = root;
		main();
	}

	private void main() {

		props = loadProperties(base_dir+File.separator+"build.properties");
		Enumeration keys = props.keys();
		while (keys.hasMoreElements()) {
			String key = (String)keys.nextElement();
			System.out.println(key+": "+props.getProperty(key));
		}

		menuBar = new JMenuBar();

		fileMenu = new JMenu("File");
		menuBar.add(fileMenu);

		JMenuItem close = new JMenuItem("Close");
		close.addActionListener(this);
		close.setActionCommand("close");
		fileMenu.add(close);


		setJMenuBar(menuBar);

		setTitle("Configuration window");
        setSize(500, 400);
        setVisible(true);
        setLocation(getX()+20,getY()+20);

		// create tabbed pane
		tabbedPane = new JTabbedPane();
   		getContentPane().add(tabbedPane);


		// JARS
		JPanel jarConfig = new JPanel();
		tabbedPane.add("Jars",jarConfig);

		Box tvline = new Box(BoxLayout.X_AXIS);
		javatv_jar = new JTextField(25);

		Box jmfline = new Box(BoxLayout.X_AXIS);
		jmf_jar = new JTextField(25);

		Box javaline = new Box(BoxLayout.X_AXIS);
		java = new JTextField(25);


		javatv_jar.setText(props.getProperty("javatv.class.path",""));
		jmf_jar.setText(props.getProperty("jmf.class.path",""));
		java.setText(props.getProperty("java.class.path",""));


		JButton browsejavatvdir = new JButton("Browse");
		browsejavatvdir.addActionListener(this);
		browsejavatvdir.setActionCommand("javatv_jar");
		JLabel javatvlabel = new JLabel("JavaTV.jar path: ");
		tvline.add(javatvlabel);
		tvline.add(javatv_jar);
		tvline.add(browsejavatvdir);
		jarConfig.add(tvline);


		JButton browsejmfdir = new JButton("Browse");
		browsejmfdir.addActionListener(this);
		browsejmfdir.setActionCommand("jmf_jar");
		JLabel jmflabel = new JLabel("jmf.jar path: ");
		jmfline.add(jmflabel);
		jmfline.add(jmf_jar);
		jmfline.add(browsejmfdir);
		jarConfig.add(jmfline);

		JButton browsejavadir = new JButton("Browse");
		browsejavadir.addActionListener(this);
		browsejavadir.setActionCommand("java");
		JLabel javalabel = new JLabel("Java SDK path: ");
		javaline.add(javalabel);
		javaline.add(java);
		javaline.add(browsejavadir);
		jarConfig.add(javaline);


		Box line5 = new Box(BoxLayout.X_AXIS);
		JButton jarsave = new JButton("Save");
		jarsave.addActionListener(this);
		jarsave.setActionCommand("save");
		line5.add(new Box.Filler(new Dimension(0,25), new Dimension(340,25), new Dimension(getWidth(),25)));
		line5.add(jarsave);


		jarConfig.add(line5);

		validate();

	}

	/* 10.12.2004 tejopa*/
	public void  setSelectedIndex(int i) {
		tabbedPane.setSelectedIndex(i);
	}

  public void actionPerformed(ActionEvent event)   {
		String cmd = event.getActionCommand();
		if (cmd=="close") { setVisible(false); System.exit(0); return; }

		if (cmd=="javatv_jar") {
	        JFileChooser fc = new JFileChooser();
	        fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
			try {
				fc.setCurrentDirectory(new File(""));
			}
			catch (Exception e) { }
			int returnVal = fc.showOpenDialog(this);
			File file = fc.getSelectedFile();
			if (file!=null) {
				try {
					String filename = file.getAbsolutePath();
					javatv_jar.setText(filename);
				}
				catch (Exception e) {
					System.out.println(e);
				}
			}
			return;
		}
		if (cmd=="jmf_jar") {
	        JFileChooser fc = new JFileChooser();
	        fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
			try {
				fc.setCurrentDirectory(new File(""));
			}
			catch (Exception e) { }
			int returnVal = fc.showOpenDialog(this);
			File file = fc.getSelectedFile();
			if (file!=null) {
				try {
					String filename = file.getAbsolutePath();
					jmf_jar.setText(filename);
				}
				catch (Exception e) {
					System.out.println(e);
				}
			}
			return;
		}

		if (cmd=="java") {
	        JFileChooser fc = new JFileChooser();
	        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			try {
				fc.setCurrentDirectory(new File(""));
			}
			catch (Exception e) { }
			int returnVal = fc.showOpenDialog(this);
			File file = fc.getSelectedFile();
			if (file!=null) {
				try {
					String filename = file.getAbsolutePath();
					java.setText(filename);
				}
				catch (Exception e) {
					System.out.println(e);
				}
			}
			return;
		}

		if (cmd=="save") {
			try {
				props.setProperty("javatv.class.path",javatv_jar.getText());
				props.setProperty("jmf.class.path",jmf_jar.getText());
				props.setProperty("java.class.path",java.getText());
				saveProperties(base_dir+File.separator+"build.properties",props);

				/** save classpaths also to OpenMHP / tejopa 6.5.2005 **/
				String prstr = base_dir+File.separator+"mhp"+File.separator+"static"+File.separator+"openmhp.properties";
                Properties p = loadProperties(prstr);
                p.setProperty("javatv_jar",javatv_jar.getText());
                p.setProperty("jmf_jar",jmf_jar.getText());

                saveProperties(prstr,p);

				setVisible(false);
			}
			catch (Exception e) { System.out.println(e.toString()); }

			System.exit(0);
			return;

		}

    }


	public void mouseClicked(MouseEvent e) {
		int clicks = e.getClickCount();
		if (clicks==2) {

		}
		if (e.getButton()==MouseEvent.BUTTON3) {
			//popupmenu.show(applicationList, e.getX(), e.getY());

		}
	}

	public void mouseEntered(MouseEvent e) { }
	public void mouseExited(MouseEvent e) { }
	public void mousePressed(MouseEvent e) { }
	public void mouseReleased(MouseEvent e) { }

	class ClassFilter extends javax.swing.filechooser.FileFilter {

		public ClassFilter() { }

		public boolean accept(File f) {
			if (f.getName().indexOf(".class")!=-1) {
				return true;
			}
			if (f.isDirectory()) {
				return true;
			}
			else {
				return false;
			}
		}

		public String getDescription() {
			return "Java class files";
		}

	}

	public static Properties loadProperties(String filename) {
		Properties p = new Properties();
		FileInputStream fis = null;
		try {
			fis = new FileInputStream(filename);
			try {	p.load(fis);	}
			catch (IOException e) {
				System.out.println(e.toString());
				}
			}
		catch (Exception e) {
			System.out.println("Error while loading properties file >"+filename+"< "+e.toString());
			}
		//System.out.println("Properties file >"+filename+"< loaded.");
		return p;
	}

	public static void saveProperties(String filename, Properties props) {
		FileOutputStream fos = null;
		try {
			fos = new FileOutputStream(filename);
			try {	props.store(fos,null);	}
			catch (IOException e) {
				System.out.println(e.toString());
				}
			}
		catch (Exception e) {
			System.out.println("Error while saving properties file >"+filename+"< "+e.toString());
			}
		System.out.println("Properties file >"+filename+"< saved.");
	}

}
