package org.davic.mpeg;

import org.openmhp.util.Out;

/**
* @author tejopa
* @date 7.3.2004
* @date 14.11.2004 added implementations, docs
* @status partially implemented
* @module internal, streams
* @HOME
*
*
*
* This class is used to represent a Service within an MPEG Transport Stream.
*/
public class Service{

	ElementaryStream[] elementaryStreams;
	ElementaryStream elementaryStream;
	TransportStream transportStream;
	int serviceID = 0;

	protected Service()	{
		Out.printMe(Out.TODO);
	}

	/**
	* a reference to the TransportStream object to which this Service belongs.
	*/
	public TransportStream getTransportStream()	{
		Out.printMe(Out.TRACE);
		return transportStream;
	}

	/**
	*	the service_id (or equivalently the program_number)
	*	of this service.
	*/
	public int getServiceId(){
		Out.printMe(Out.TRACE);
		return serviceID;
	}

	/**
	    Parameters:
	        pid - the value of MPEG-2 Transport Stream
	        packets that carry the elementary stream.
	    Returns:
	        a reference to the ElementaryStream object that
	        represents the Elementary Stream carried
	        by packets with the specified PID. Null is
	        returned if the specified PID is not present
	        within this service or if no Elementary Stream
	        is carried by the specified PID or if the required
	        information is not available.
	*/
	public ElementaryStream retrieveElementaryStream(int pid){
		Out.printMe(Out.TRACE);
		ElementaryStream result = null;
		for (int i=0;i<elementaryStreams.length;i++) {
			if (elementaryStreams[i].getPID()==pid) {
				result = elementaryStreams[i];
			}
		}
		return result;
	}

	/**
	*	the array of all ElementaryStream objects
	*	present within this service. When the required
	*	information is not available null is returned.
	*/
	public ElementaryStream[] retrieveElementaryStreams(){
		Out.printMe(Out.TRACE);
		return elementaryStreams;
	}

}

