package org.davic.mpeg.sections;

import org.openmhp.util.Out;

/**
* @author tejopa
* @date 7.3.2004
* @date 14.11.2004 implementation, docs
* @status partially implemented
* @module internal
* @HOME
*/
public class Section implements java.lang.Cloneable{

	byte[] data;
	int tableId = -1;
	boolean sectionSyntaxIndicator = false;
	boolean privateIndicator = false;
	int sectionLength = 0;
	int tableIdExtension = 0;
	short versionNumber = 0;
	boolean currentNextIndicator = false;
	int sectionNumber = 0;
	int lastSectionNumber = 0;
	boolean fullStatus = false;

	Section(){
		Out.printMe(Out.TODO);
	}

	/**
    This method returns all data from the filtered section in the Section object, including the section header. Each call to this method results in a new a copy of the section data.
    Throws:	NoDataAvailableException - if no valid data is available.
	*/
	public byte[] getData()	throws NoDataAvailableException	{
		Out.printMe(Out.TRACE);
		if (!fullStatus) throw new NoDataAvailableException();
		byte[] result = new byte[data.length];
		System.arraycopy(data,0,result,0,result.length);
		return result;
	}

	/**
    This method returns the specified part of the filtered data. Each call to this method results in a new a copy of the section data.

    Parameters:
        index - defines within the filtered section the index of the first byte of the data to be retrieved. The first byte of the section (the table_id field) has index 1.
        length - defines the number of consecutive bytes from the filtered section to be retrieved.
    Throws:
        NoDataAvailableException - if no valid data is available.
        java.lang.IndexOutOfBoundsException - if any part of the filtered data requested would be outside the range of data in the section.

	*/
	public byte[] getData(int index, int length) throws NoDataAvailableException, java.lang.IndexOutOfBoundsException{
		index--;
		Out.printMe(Out.TRACE);
		if (!fullStatus) throw new NoDataAvailableException();
		if ((index<0)|(index>data.length)|((index+length)>data.length)) {
			throw new IndexOutOfBoundsException();
		}
		byte[] result = new byte[length];
		System.arraycopy(data,index,result,0,result.length);
		return result;
	}

	/**
    This method returns one byte from the filtered data.

    Parameters:
        index - defines within the filtered section the index of the byte to be retrieved. The first byte of the section (the table_id field) has index 1.
    Throws:
        NoDataAvailableException - if no valid data is available.
        java.lang.IndexOutOfBoundsException - if the byte requested would be outside the range of data in the section.
	*/
	public byte getByteAt(int index) throws NoDataAvailableException, java.lang.IndexOutOfBoundsException{
		index--;
		if (!fullStatus) throw new NoDataAvailableException();
		if ((index<0)|(index>data.length)) throw new IndexOutOfBoundsException();
		Out.printMe(Out.TRACE);
		return data[index];
	}

	/**
	This method returns the value of the corresponding
	field from an MPEG-2 section header.
	*/
	public int table_id() throws NoDataAvailableException{
		Out.printMe(Out.TRACE);
		if (!fullStatus) throw new NoDataAvailableException();
		return tableId;
	}

	/**
    This method returns the value of the corresponding field from an MPEG-2 section header.

    Throws:
        NoDataAvailableException - thrown if no valid data is available
	*/
	public boolean section_syntax_indicator() throws NoDataAvailableException{
		Out.printMe(Out.TRACE);
		if (!fullStatus) throw new NoDataAvailableException();
		return sectionSyntaxIndicator;
	}

	/**
    This method returns the value of the corresponding field from an MPEG-2 section header.

    Throws:
        NoDataAvailableException - thrown if no valid data is available
	*/
	public boolean private_indicator() throws NoDataAvailableException	{
		Out.printMe(Out.TRACE);
		if (!fullStatus) throw new NoDataAvailableException();
		return privateIndicator;
	}

	/**
    This method returns the value of the corresponding field from an MPEG-2 section header.

    Throws:
        NoDataAvailableException - thrown if no valid data is available
	*/
	public int section_length()	throws NoDataAvailableException	{
		Out.printMe(Out.TRACE);
		if (!fullStatus) throw new NoDataAvailableException();
		return sectionLength;
	}

	/**
    This method returns the value of the corresponding field from an MPEG-2 section header.
    Throws:
        NoDataAvailableException - thrown if no valid data is available
	*/
	public int table_id_extension()	throws NoDataAvailableException	{
		Out.printMe(Out.TRACE);
		if (!fullStatus) throw new NoDataAvailableException();
		return tableIdExtension;
	}

	/**
    This method returns the value of the corresponding field from an MPEG-2 section header.
    Throws:
        NoDataAvailableException - thrown if no valid data is available
	*/
	public short version_number() throws NoDataAvailableException{
		Out.printMe(Out.TRACE);
		if (!fullStatus) throw new NoDataAvailableException();
		return versionNumber;
	}

	/**
    This method returns the value of the corresponding field from an MPEG-2 section header.
    Throws:        NoDataAvailableException - thrown if no valid data is available
	*/
	public boolean current_next_indicator()	throws NoDataAvailableException{
		Out.printMe(Out.TRACE);
		if (!fullStatus) throw new NoDataAvailableException();
		return currentNextIndicator;
	}

	/**
    This method returns the value of the corresponding field from an MPEG-2 section header.
    Throws:        NoDataAvailableException - thrown if no valid data is available
	*/
	public int section_number()	throws NoDataAvailableException	{
		Out.printMe(Out.TRACE);
		if (!fullStatus) throw new NoDataAvailableException();
		return sectionNumber;
	}

	/**
    This method returns the value of the corresponding field from an MPEG-2 section header.
    Throws:        NoDataAvailableException - thrown if no valid data is available
	*/
	public int last_section_number() throws NoDataAvailableException{
		Out.printMe(Out.TRACE);
		if (!fullStatus) throw new NoDataAvailableException();
		return lastSectionNumber;
	}

	/**
    This method reads whether a Section object contains valid data.
    Returns: true when the Section object contains valid data otherwise false
	*/
	public boolean getFullStatus(){
		Out.printMe(Out.TRACE);
		return fullStatus;
	}

	/**
	This method sets a Section object such that any data contained within it is no longer valid. This is intended to be used with RingSectionFilters to indicate that the particular object can be re-used.
	*/
	public void setEmpty()	{
		Out.printMe(Out.TRACE);
		fullStatus = false;
	}

	/**
    Create a copy of this Section object. A cloned Section object is a new and separate object. It is unaffected by changes in the state of the original Section object or restarting of the SectionFilter the source Section object originated from.
    Overrides:      clone in class java.lang.Object
	*/
	public Object clone() {
		Out.printMe(Out.TODO,"returns null");
		return null;
	}
}
