package org.davic.net.ca;

import org.davic.mpeg.ElementaryStream;
import org.davic.mpeg.Service;
import org.davic.mpeg.TransportStream;

import org.openmhp.util.Out;

/**
* @author tejopa
* @date 7.3.2004
* @date 14.11.2004 docs
* @status not implemented
* @module CA
* TODO create module to adaptation layer, create CA-emulator
* @HOME

CAModule class represents a physical CA Module

*/
public abstract class CAModule {

	public final static int CA0 = 0x00;
	public final static int CA1 = 0x01;
	public final static int PROPRIETARY = 0xFF;

	public final static int ENTITLEMENT_UNKNOWN = 0x00;
	public final static int ENTITLEMENT_AVAILABLE = 0x01;
	public final static int ENTITLEMENT_NOT_AVAILABLE = 0x02;
	public final static int MMI_DIALOGUE_REQUIRED = 0x03;

	public CAModule() {
		Out.printMe(Out.TRACE);
	}

	/**
    Returns if descrambling is possible for specified service or future event (specified by a Locator).

    Return values are specified by constants in this class. In case of DVB Common Interface, this maps onto CI messages as follows:

        * when the Locator points to a service and the terminal is currently receiving the transport stream that this service is carried in and this transport stream is available to this CA module, then this method is mapped to a ca_pmt message with ca_pmt_cmd_id set to query. The value returned in the ca_pmt_reply is mapped as defined in the documentation of the constants in the class. If the module is currently descrambling the service and the terminal is aware of this, ENTITLEMENT_AVAILABLE shall be returned immediately without communicating with the module.
        * when the Locator points to a service that is not carried in a currently received transport stream, ENTITLEMENT_UNKNOWN shall be returned.
        * when the Locator points to an event, this maps onto event_query with event_cmd_id = query (Common Interface specification, section B.4.1.1). The return values is mapped as defined in the documentation of the constants in this class.

    Parameters:
        locator - a Locator that points to a broadcast service or an event of a service
    Returns:
        descrambling status code
    Throws:
        NoFreeCapacityException - raised if the CAModule does not have available capacity to perform this action now
        ModuleUnavailableException - raised if the physical CA module has been removed and is not available any more
        java.lang.SecurityException - raised if the application does not have an instance of CAPermission with the "entitlementInfo" name.
        InvalidLocatorException - if the locator does not point to a valid service or event.
	*/
	public int queryEntitlement(org.davic.net.Locator locator) throws CAException,	org.davic.net.InvalidLocatorException {
		Out.printMe(Out.TODO,"returns 0");
		return 0;
	}

	/**
    Request to buy a specified service or future event (specified by a Locator) from a conditional access system.

    Returns whether descrambling of the specified service or future event is possible after the user dialogue has been completed. Return values are specified by constants in this class. If a dialog is required to buy an entitlement, this dialog may be started.

    In case of DVB Common Interface, this maps onto CI messages as follows:

        * when the Locator points to a service and the terminal is currently receiving the transport stream that this service is carried in and this transport stream is available to this CA module, then this method is mapped to a ca_pmt message with ca_pmt_cmd_id set to 'ok_mmi'. The value returned in the ca_pmt_reply is mapped as defined in the documentation of the constants in the class. If the module is currently descrambling the service and the terminal is aware of this, ENTITLEMENT_AVAILABLE shall be returned immediately without communicating with the module.
        * when the Locator points to a service that is not carried in a currently received transport stream, NotTunedException is thrown
        * when the Locator points to an event, this maps onto event_query message with event_cmd_id set to 'mmi' (Common Interface specification,section B.4.1.1). The value returned in the event_reply message is mapped as defined in the documentation of the constants in this class.

    Parameters:
        locator - Locator that points to a broadcast service or an event of a service
    Returns:
        descrambling status code (similar as in queryEntitlement)
    Throws:
        NoFreeCapacityException - raised if the CAModule does not have available capacity to perform this action now
        ModuleUnavailableException - raised if the physical CA module has been removed and is not available any more
        NotTunedException - raised if performing the action would require being tuned to the transport stream carrying the service and the receiver is not currently tuned to it
        java.lang.SecurityException - raised if the application does not have an instance of CAPermission with the "buy" name.
	*/
	public int buyEntitlement(org.davic.net.Locator locator) throws CAException {
		Out.printMe(Out.TODO,"returns 0");
		return 0;
	}

	/**
    Returns the entitlements present in this module for display to the end-user. The strings returned are CA system dependent. The CA system and implementation of this API together should format these such that they can be presented to end users.

    Returns:
        array of entitlement strings
    Throws:
        ModuleUnavailableException - raised if the physical CA module has been removed and is not available any more
        java.lang.SecurityException - raised if the application does not have an instance of CAPermission with the "entitlementInfo" name.
	*/
	public String[] listEntitlements() throws CAException {
		Out.printMe(Out.TODO,"returns null");
	    return null;
	}

	/**
    Returns true if the given transport stream can be connected to this module

    Returns:
        true, if the transport stream can be connected to this CA module, false otherwise
    Throws:
        ModuleUnavailableException - raised if the physical CA module has been removed and is not available any more
        NotTunedException - raised if performing the action would require being tuned to the transport stream carrying the service and the receiver is not currently tuned to it
	*/
	public boolean isConnectable(TransportStream ts) throws CAException {
		Out.printMe(Out.TODO,"returns false");
	    return false;
	}

	/**
    Returns the number of the slot where module is connected. The numbering of slots is dependent on the API implementation, but should be such that if the number is presented to the end user, he can identify which physical slot it is.

    Returns:
        slot number
    Throws:
        ModuleUnavailableException - raised if the physical CA module has been removed and is not available any more
	*/
	public int getSlotNumber() throws CAException {
		Out.printMe(Out.TODO,"returns 0");
		return 0;
	}

	/**
    Returns true if given service can be descrambled by this CAModule now. The difference between this function and the queryEntitlement is that this function returns whether this CA module can descramble this service now, i.e. if it has both the entitlement as well as resources to perform it. In case of CA0 this maps onto ca_pmt with ca_pmt_cmd_id = query (Common Interface specification, section 8.4.3.4).

    Returns:
        true, if descrambling of the service could be performed now, false otherwise
    Throws:
        NotTunedException - raised if performing the action would require being tuned to the transport stream carrying the service and the receiver is not currently tuned to it
        ModuleUnavailableException - raised if the physical CA module has been removed and is not available any more
	*/
	public boolean isDescramblable(Service s) throws CAException {
		Out.printMe(Out.TODO,"returns false");
		return false;
	}

	/**
    Returns true if the given array of elementary services (which are components of the same service) can be descrambled by this CAModule. The difference between this function and the queryEntitlement is that this function returns whether this CA module can descramble this service now, i.e. if it has both the entitlement as well as resources to perform it. In case of CA0 this maps onto ca_pmt with ca_pmt_cmd_id = query (Common interface specification, section 8.4.3.4).

    Returns:
        true, if descrambling of these elementary streams could be performed now or if an empty array was passed in, false otherwise
    Throws:
        NotTunedException - raised if performing the action would require being tuned to the transport stream carrying the service and the receiver is not currently tuned to it
        ModuleUnavailableException - raised if the physical CA module has been removed and is not available any more
	*/
	public boolean isDescramblable(ElementaryStream[] streams) throws CAException {
		Out.printMe(Out.TODO,"returns false");
		return false;
    }

	/**
    Returns all CASystemIDs of this CA module.

    Returns:
        array of CA system identifiers
    Throws:
        ModuleUnavailableException - raised if the physical CA module has been removed and is not available any more
	*/
	public int[] getCASystemIDs() throws CAException {
		Out.printMe(Out.TODO,"returns false");
		return null;
	}


	/**
    Returns the type of this module. Constants for the possible return values are defined in this class

    Returns:
        module type
    Throws:
        ModuleUnavailableException - raised if the physical CA module has been removed and is not available any more
	*/
	public int getModuleType() throws CAException {
		Out.printMe(Out.TODO,"returns 0");
		return 0;
	}

	/**
    This method allows an application to open a message session to this module. The return value of this method is the session_id that is a unique identification of the session within the module. In a DVB CI/DAVIC CA0 system, this method can only be used to address private resources and not public ones as defined in .

    In systems based on the DVB common interface, messages sessions opened using this method shall be mapped onto the CA pipeline for the module represented by this CAModule instance as defined in section 6.8 of the common interface extensions specification. Neither the module_id or the resource_id of the module are visible to the application. It is the responsibility of the platform to perform the relevant mapping. NOTE:The document referred to as "common interface extensions specification."is TS 101 699.

    Parameters:
        listener - the listener which will receive the messages related to this message session
    Returns:
        the session identifier
    Throws:
        ModuleUnavailableException - raised if the physical CA module has been removed and is not available any more
        ModuleBusyException - raised if the module is busy and is not able to handle a message session at the moment. This is CA system dependant.
        ModuleResourceNonExistentException - raised if the specified resource is not present in the module.
        ModuleResourceVersionTooLowException - raised if the version of the module resource is too low. NOTE: The ModuleResourceVersionTooLowException shall never be thrown in this version of this specification.
        java.lang.SecurityException - raised if the application does not have an instance of CAPermission with the "messagePassing" name.
	*/
	public int openMessageSession(MessageListener listener) throws CAException {
		Out.printMe(Out.TODO,"returns 0");
		return 0;
    }

	/**
    This method allows an application to close a session to this module. After this method has returned, no new messages will be accepted in this session. Messages that have already been submitted will however be answered. After the last 'ModuleResponseEvent' a 'SessionClosedEvent' will follow.

    Parameters:
        session_id - the session identifier returned by the openMessageSession method.
    Throws:
        ModuleUnavailableException - raised if the physical CA module has been removed and is not available any more
        UnknownSessionException - raised if the specified session does not exist
	*/
	public void closeMessageSession(int session_id) throws CAException {
		Out.printMe(Out.TODO);
	}

	/**
    Sends a message to this module. The sending of the message is asynchronous. In systems based on the DVB common interface, messages sent using this method shall be mapped onto the CAPipelineRequest as defined in section 6.8.3 of the common interface extensions specification. Responses from the CA system reported through the CAPipelineResponse and CAPipelineNotification messages shall be mapped onto instances of ModuleResponseEvent.

    Parameters:
        session_id - the session identifier returned by the openMessageSession method
        msg - the message to be sent to the module
    Throws:
        ModuleUnavailableException - raised if the physical CA module has been removed and is not available any more
        UnknownSessionException - raised if the specified session does not exist
        BufferFullException - raised if the message buffer is full
	*/
	public void sendToModule(int session_id, CAMessage msg) throws CAException {
		Out.printMe(Out.TODO);
	}

	/**
    Retrieves the Application Title String. This functionality is provided at low lowel (within MMI and Application Information sessions defined in EN50221) by the message application_info() message (Application Information resource, see 8. 4.2.2)

    Returns:
        the application title string
    Throws:
        ModuleUnavailableException - raised if the physical CA module has been removed and is not available any more
	*/
	public String getApplicationTitle() throws ModuleUnavailableException{
		Out.printMe(Out.TODO);
		return null;
	}

	/**
    Requests the module to enter start the application and enter the main application menu. This functionality is provided at low lowel (within MMI and Application Information sessions defined in EN50221) by the message enter_menu() message (Application Information resource, see 8.4.2.3)

    Throws:
        ModuleUnavailableException - raised if the physical CA module has been removed and is not available any more
	*/
	public void enterApplication() throws ModuleUnavailableException {
		Out.printMe(Out.TODO);
	};

	/**
    Requests the module to leave the complete tree of the current high-level MMI dialogs. This functionality is provided at low lowel (within MMI and Application Information sessions defined in EN50221) by the message close_mmi() message (MMI resource, see 8.6.2.1)

    Throws:
        ModuleUnavailableException - raised if the physical CA module has been removed and is not available any more
	*/
    public void closeMMI() throws ModuleUnavailableException {
		Out.printMe(Out.TODO);
    }

}





