package org.dvb.dsmcc;

import java.io.File;
import java.io.InterruptedIOException;
import java.net.URL;
import java.security.cert.X509Certificate;

import org.openmhp.util.LinkedList;
import org.openmhp.util.Out;

/**
* @author tejopa
* @date 16.2.2004
* @status partially implemented
* @module internal, dsmcc
* @TODO create events for listeners
*/
public class DSMCCObject extends File {

    public static final int FROM_CACHE = 1;
    public static final int FROM_CACHE_OR_STREAM = 2;
    public static final int FROM_STREAM_ONLY = 3;

	static String base = "";
	static String separator = "";

	private LinkedList listeners;

	static {
		base = (new File("")).getAbsolutePath();
		separator = System.getProperty("file.separator", "\\");
	}
	
	private String file = "";

	private String getFullname() { return base+separator+file; }

    public DSMCCObject(String s)    {
        super(base,s);
        file = s;
		Out.printMe(Out.TRACE);
		if (!exists()) {
			Out.printMe(Out.ERROR,"FILE DOES NOT EXIST"+s);
		}
		else {
    		listeners = new LinkedList();
		}
    }

    public DSMCCObject(String s, String s1) {
        super(s);
		Out.printMe(Out.TODO,"NOT IMPLEMENTED!");
		listeners = new LinkedList();
    }

    public DSMCCObject(DSMCCObject dsmccobject, String s)    {
        super(base,s);
        file = s;
		Out.printMe(Out.TRACE,"dir : "+dsmccobject.toString()+" file: "+s);
		if (!exists()) {
			Out.printMe(Out.ERROR,"FILE DOES NOT EXIST"+s);
		}
		else {
		    listeners = new LinkedList();
    	}
    }

    public boolean isLoaded() {
		Out.printMe(Out.TODO);
		return true;
    }

    public boolean isStream()    {
		Out.printMe(Out.TODO);
		return true;
    }

    public boolean isStreamEvent()    {
		Out.printMe(Out.TODO);
        return true;
    }

    public boolean isObjectKindKnown()    {
		Out.printMe(Out.TODO);
        return true;
    }

    public void synchronousLoad() throws InvalidFormatException, InterruptedIOException, MPEGDeliveryException, ServerDeliveryException, InvalidPathNameException, NotEntitledException, ServiceXFRException    {
		Out.printMe(Out.TODO);
    }

	/**
	* @author DCcoder
	* @date 8.2.2005
	*/
	public void asynchronousLoad(AsynchronousLoadingEventListener asynchronousloadingeventlistener) throws InvalidPathNameException   
    {
        if (exists())
            asynchronousloadingeventlistener.receiveEvent(new SuccessEvent(this));
        else
            asynchronousloadingeventlistener.receiveEvent(new InvalidPathnameEvent(this));
    } 

    public void abort() throws NothingToAbortException    {
		Out.printMe(Out.TODO);
    }

    public static boolean prefetch(String s, byte byte0)    {
		Out.printMe(Out.TODO,"returns true");
        return true;
    }

    public static boolean prefetch(DSMCCObject dsmccobject, String s, byte byte0)    {
		Out.printMe(Out.TODO,"returns true");
        return true;
    }

    public void unload() throws NotLoadedException    {
		Out.printMe(Out.TODO);
    }

    public URL getURL()    {
		Out.printMe(Out.TODO,"returns null");
        return null;

    }

    public void addObjectChangeEventListener(ObjectChangeEventListener objectchangeeventlistener) throws InsufficientResourcesException {
		listeners.add(objectchangeeventlistener);
		Out.printMe(Out.TRACE);
    }

    public void removeObjectChangeEventListener(ObjectChangeEventListener objectchangeeventlistener) {
		listeners.remove(objectchangeeventlistener);
		Out.printMe(Out.TRACE);
    }

    public void loadDirectoryEntry(AsynchronousLoadingEventListener asynchronousloadingeventlistener) throws InvalidPathNameException {
		Out.printMe(Out.TODO);
    }

    public void setRetrievalMode(int i) {
		Out.printMe(Out.TODO);
    }

    public X509Certificate[][] getSigners()    {
		Out.printMe(Out.TODO,"returns null");
		return null;
    }

}