package org.dvb.io.persistent;

/**
* @author tejopa
* @date 7.3.2004
* @date 18.11.2004 fully implemented
* @status fully implemented
* @module internal, file, security
* @HOME
*/
public class FileAccessPermissions {

    boolean rwar = false;
    boolean wwar = false;
    boolean roar = false;
    boolean woar = false;
    boolean raar = false;
    boolean waar = false;


	public FileAccessPermissions(boolean readWorldAccessRight, boolean writeWorldAccessRight,
		boolean readOrganisationAccessRight, boolean writeOrganisationAccessRight,
		boolean readApplicationAccessRight, boolean writeApplicationAccessRight) {
        rwar = readWorldAccessRight;
        wwar = writeWorldAccessRight;
        roar = readOrganisationAccessRight;
        woar = writeOrganisationAccessRight;
        raar = readApplicationAccessRight;
        waar = writeApplicationAccessRight;
    }

	public boolean hasReadWorldAccessRight() { return rwar;}

	public boolean hasWriteWorldAccessRight() {return wwar;}

	public boolean hasReadOrganisationAccessRight() {return roar;}

	public boolean hasWriteOrganisationAccessRight() {return woar;}

	public boolean hasReadApplicationAccessRight() {return raar;}

	public boolean hasWriteApplicationAccessRight() {return waar;}

	public void setPermissions(boolean readWorldAccessRight,
		boolean writeWorldAccessRight, boolean readOrganisationAccessRight,
		boolean writeOrganisationAccessRight, boolean readApplicationAccessRight,
		boolean writeApplicationAccessRight) {
        rwar = readWorldAccessRight;
        wwar = writeWorldAccessRight;
        roar = readOrganisationAccessRight;
        woar = writeOrganisationAccessRight;
        raar = readApplicationAccessRight;
        waar = writeApplicationAccessRight;
    }
}
