package org.dvb.ui;

import java.awt.*;
import java.awt.image.*;
import java.text.AttributedCharacterIterator;

import org.openmhp.util.*;


/**
* @author tejopa
* @date 7.3.2004
* @date 6.9.2004 finished some methods
* @date 4.11.2004 added constructor DVBGraphicsImpl(Graphics2D g) // erroneus text replaced 10.12.2004 tejopa
* @date 1.12.2004 fixed create() 
* @status partially implemented
* @module internal
* @HOME
*/
public class DVBGraphicsImpl extends DVBGraphics implements Cloneable {

	private Graphics graphics;
	private DVBAlphaComposite alphaComposite = DVBAlphaComposite.getInstance(2);

	private BufferedImage currentImage;
	private Graphics bufferedGraphics;

	public final static int NO_PALETTE = 1;
	public final static int PALETTE = 2;
	
	private static int mode = NO_PALETTE;
	
	public Graphics getGraphics() {
		Out.printMe(Out.TRACE);
		return graphics;
	}

    public DVBGraphicsImpl(Graphics g) {
		super();
		graphics = g;
		//currentImage = new BufferedImage(720,576,BufferedImage.TYPE_INT_RGB);
		//graphics = currentImage.getGraphics();
		
	}

    public DVBGraphicsImpl(Graphics2D g) {
		super();
		graphics = g;
	}

	public Image getCurrentImage() {
		return currentImage;	
	}

	public int[] getAvailableCompositeRules()   {
		Out.printMe(Out.TODO);
		return new int[0];
	}

    public DVBColor getBestColorMatch(Color color) {
		//Out.printMe(Out.TODO);
		if (mode==NO_PALETTE) { return new DVBColor(color); }
		else {
			return new DVBColor(MHPPaletteUtil.getInstance().getMatch(color));	
		}
    }

    public Color getColor() {		return graphics.getColor();	}

    public DVBAlphaComposite getDVBComposite() {return alphaComposite;	}

    public int getType() {
		Out.printMe(Out.TODO);
        return 0;
    }

    public void setColor(Color color) {
		//Out.printMe(Out.TRACE);
		if (mode==NO_PALETTE) {
			graphics.setColor(color);
		}
		else {
			graphics.setColor(MHPPaletteUtil.getInstance().getMatch(color));
		}
	}

    public void setDVBComposite(DVBAlphaComposite dvbalphacomposite) throws UnsupportedDrawingOperationException {
		//Out.printMe(Out.TRACE,dvbalphacomposite.toString());
		alphaComposite = dvbalphacomposite;
	}

    public String toString() { return getClass().getName() + "[font=" + getFont() + ",color=" + getColor() + "]";    }

	public void clearRect(int x, int y, int width, int height) { graphics.clearRect(x,y,width,height); }

	public void clipRect(int x, int y, int width, int height) { graphics.clipRect(x,y,width,height); }

	public void copyArea(int x, int y, int width, int height, int dx, int dy) { Out.printMe(Out.TODO); }

	/* tejopa 1.12.2004*/
	public Graphics create() {
		return new DVBGraphicsImpl(graphics.create());
	}

 	public Graphics create(int x, int y, int width, int height) {
 		Out.printMe(Out.TODO);
		return null;
	}

	public void dispose() { graphics.dispose(); }

 	public void draw3DRect(int x, int y, int width, int height, boolean raised)  { graphics.draw3DRect(x,y,width,height,raised); }

	public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle)  { graphics.drawArc(x,y,width,height,startAngle,arcAngle); }

 	public void drawBytes(byte[] data, int offset, int length, int x, int y)  { graphics.drawBytes(data,offset,length,x,y); }

 	public void drawChars(char[] data, int offset, int length, int x, int y)  { graphics.drawChars(data,offset,length,x,y); }

	public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer)  {
		//Out.printMe(Out.TRACE);
		graphics.drawImage(img,x,y,bgcolor,observer);
		return true;
	}

	public boolean drawImage(Image img, int x, int y, ImageObserver observer)  {
		graphics.drawImage(img,x,y,observer);
		return true;
	}

	public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer)  {
		graphics.drawImage(img,x,y,width,height,bgcolor,observer);
		return true;
	}

	public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer)  {
		graphics.drawImage(img,x,y,width,height,observer);
		return true;
	}

	public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer)  {
		//Out.printMe(Out.TRACE);
		graphics.drawImage(img,dx1,dy1,dx2,dy2,sx1,sy1,sx2,sy2,bgcolor,observer);
		return true;
	}

	public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer)  {
		//Out.printMe(Out.TRACE);
		graphics.drawImage(img,dx1,dy1,dx2,dy2,sx1,sy1,sx2,sy2,observer);
		return true;
	}

	public void drawLine(int x1, int y1, int x2, int y2)  {	graphics.drawLine(x1,y1,x2,y2);	}

	public void drawOval(int x, int y, int width, int height)  { graphics.drawOval(x,y,width,height); }

	public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints)  { graphics.drawPolygon(xPoints,yPoints,nPoints); }

	public void drawPolygon(Polygon p)  { graphics.drawPolygon(p); }

	public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints)  { graphics.drawPolyline(xPoints,yPoints,nPoints); }

	public void drawRect(int x, int y, int width, int height)  { graphics.drawRect(x,y,width,height); }

	public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight)  { graphics.drawRoundRect(x,y,width,height,arcWidth,arcHeight); }

	public void drawString(AttributedCharacterIterator iterator, int x, int y)  { 	graphics.drawString(iterator,x,y);	}

	public void drawString(String str, int x, int y)  {	
//	Out.println(this,"drawString "+str);
	graphics.drawString(str,x,y);	}

	public void fill3DRect(int x, int y, int width, int height, boolean raised)  { graphics.fill3DRect(x,y,width,height,raised); }

	public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle)  { graphics.fillArc(x,y,width,height,startAngle,arcAngle); }

	public void fillOval(int x, int y, int width, int height)  { graphics.fillOval(x,y,width,height);	}

	public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints)  { graphics.fillPolygon(xPoints, yPoints, nPoints);  }

	public void fillPolygon(Polygon p)  { graphics.fillPolygon(p); }

	public void fillRect(int x, int y, int width, int height)  { graphics.fillRect(x,y,width,height); }

	public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight)  {	graphics.fillRoundRect(x,y,width,height,arcWidth,arcHeight);	}

	public void finalize()  {
		graphics.finalize();
		//Out.println(this,"finalize FIXME");
	}

	public Shape getClip()  { return graphics.getClip(); }

	public Rectangle getClipBounds()  { return graphics.getClipBounds(); }

	public Rectangle getClipBounds(Rectangle r)  { return graphics.getClipBounds(r);  }

	public Rectangle getClipRect()  { return graphics.getClipRect();  }

	public Font getFont()  { return graphics.getFont();  }

	public FontMetrics getFontMetrics()  { return graphics.getFontMetrics(); }

	public FontMetrics getFontMetrics(Font f)  { return graphics.getFontMetrics(f);	}

 	public boolean hitClip(int x, int y, int width, int height)  {	return graphics.hitClip(x,y,width,height); }

	public void setClip(int x, int y, int width, int height)  { 
		//Out.printMe(Out.TRACE,x+" "+y+" "+width+" "+height);
		graphics.setClip(x,y,width,height); }

	public void setClip(Shape clip)  {	
		//Out.printMe(Out.TRACE,clip.toString());
		graphics.setClip(clip);	}

	public void setFont(Font font)  { graphics.setFont(font);	}

	public void setPaintMode()  {
		Out.println(this,"setPaintMode FIXME");
	}

	public void setXORMode(Color c1)  { graphics.setXORMode(c1); }

	public void translate(int x, int y)  { 	
		//Out.printMe(Out.TRACE,x+" "+y);
		graphics.translate(x,y); }


	/* tejopa */
	public static void setMode(int m) {
		Out.printMe(Out.TODO,"Images are not converted to palette!");
		if (m==PALETTE) {
			mode = PALETTE;
			Out.printMe(Out.TRACE,"mode set to PALETTE");
		}
		if (m==NO_PALETTE) {
			mode = NO_PALETTE;
			Out.printMe(Out.TRACE,"mode set to NO_PALETTE");
		}	
		org.havi.ui.HSceneFactory.getInstance().getDefaultHScene().repaint();
	}


}
