package org.dvb.user;

import java.util.Hashtable;
import org.openmhp.util.LinkedList;
/**
* @author tejopa
* @date 7.3.2004
* @status fully implemented
* @module internal
* @HOME
*/
public abstract class Preference {

	private String name;
	private LinkedList values;

	protected Preference(){
		values = new LinkedList();
	}

	public Preference (String n, String value) {
		name = n;
		values = new LinkedList();
		values.add(value);
	}

	public Preference (String n, String v[]) {
		name = n;
		values = new LinkedList();
		add(v);
	}

	public void add (String value) {
		values.add(value);
	}

	public void add( String v[]){
		for (int i=0;i<v.length;i++) {
			values.add(v[i]);
		}
	}

	public void add (int position, String value) {
		values.addTo(position,value);
	}

	public String[] getFavourites () {
		String[] result = new String[values.size()];
		for (int i=0;i<values.size();i++) {
			result[i] = (String)values.get(i);
		}
		return result;
	}

	public String getMostFavourite () {
		return (String)values.get(0);
	}

	public String getName () {
		return name;
	}

	public int getPosition(String value) {
		int result = -1;
		for (int i=0;i<values.size();i++) {
			if (value.equals((String)values.get(i))) {
				result = i;
			}
		}
		return result;
	}

	public boolean hasValue() {
		boolean result = false;
		if (values.size()>0) {
			result = true;
		}
		return result;
	}

	public void remove(String value){
		int result = -1;
		for (int i=0;i<values.size();i++) {
			if (value.equals((String)values.get(i))) {
				result = i;
			}
		}
		values.remove(values.get(result));
	}

	public void removeAll(){
		values.clear();
	}

	public void setMostFavourite (String value) {
		remove(value);
		values.addTo(0,value);
	}

	public String toString() {
		String result = name;
		result+=" [";
		for (int i=0;i<values.size();i++) {
			result+=(String)values.get(i)+" ";
		}
		result+="]";
		return result;
	}
}






