package org.havi.ui;

import java.awt.*;

import org.openmhp.util.Out;
import org.dvb.ui.*;

/**
* @author tejopa
* @date 15.2.2004
* @status partially implemented
* @module internal, graphics
* @TODO check pop and to front etc methods
* @priority high
*/
public class HContainer extends Container{

    private HMatte hMatte;
    private boolean inGroup;

    public HContainer(){
		Out.printMe(Out.TRACE);
        setLayout(null);
        hMatte = null;
        inGroup = false;
    }

    public HContainer(int x, int y, int width, int height){
        setLayout(null);
        hMatte = null;
        inGroup = false;
        setBounds(x, y, width, height);
        Out.printMe(Out.TRACE,"done "+x+","+y+" "+width+"x"+height);
    }

    public void setMatte(HMatte m){
        hMatte = m;
    }

    public HMatte getMatte(){
        return hMatte;
    }

    public void group(){
        inGroup = true;
    }

    public void ungroup(){
        inGroup = false;
    }

    public boolean isGrouped(){
        return inGroup;
    }


    public boolean isDoubleBuffered(){
		Out.printMe(Out.TODO);
		return false;
    }

    public boolean isOpaque(){
		Out.printMe(Out.TODO);
		return false;
    }

	// PRIVATE ---

    private int getComponentIndex(Component component)    {
        Component c[] = getComponents();
        for(int i = 0;i<c.length; i++) {
            if(c[i]==component) {
                // found
                return i;
            }
		}
		// not found
        return -1;
    }


	// HComponentOrdering

	/** tejopa */
    public Component addAfter(Component component, Component front)    {
        if (component == front) {
            return component;
        }

        if(getComponentIndex(component) != -1) {
            pushBehind(component, front);
            return component;
        }

        if(getComponentIndex(component) == -1)
        {
            add(component);
            pushBehind(component, front);
            return component;
        }
        else {
            // error
            return null;
        }
    }

	/** tejopa */
    public Component addBefore(Component component, Component behind)    {
        if(component == behind) {
            return component;
        }
        if(getComponentIndex(behind) == -1) {
            // behind was not added
            return null;
        }
        else {
            return add(component, getComponentIndex(behind));
    	}
    }

	/** tejopa */
    public boolean pop(Component component)    {
        int i = getComponentIndex(component);
        if ( (i-1) > -1 ) {
            add(component, i-1);
            return true;
        } else {
            return false;
        }
    }

	/** tejopa */
	public boolean popInFrontOf(Component move, Component behind)    {
        if(move == behind) {
            return true;
        }
        // check if both are added
        if(getComponentIndex(move) == -1 || getComponentIndex(behind) == -1) {
            return false;
        } else {
        	add(move, getComponentIndex(behind));
            return true;
        }
    }


	/** tejopa */
    public boolean popToFront(Component component)    {
        if (component!=null) {
	        add(component, 0);
        	return true;
        }
        else {
        	return false;
        }
    }

	/** tejopa */
    public boolean push(Component component)    {
        int i = getComponentIndex(component);
        if( (i+1) < getComponentCount()) {
            add(component, i+1);
            return true;
        } else {
            return false;
        }
    }

	/** tejopa */
    public boolean pushBehind(Component move, Component front)    {
		if (move==front) {
			return true;
		}
        // check if both are added
        if(getComponentIndex(move) == -1 || getComponentIndex(front) == -1) {
            return false;
        } else {
        	int i = getComponentIndex(front);
        	if ((i+1)<getComponents().length) {
	        	add(move, i+1);
            }
            return true;
        }
    }

	/** tejopa */
    public boolean pushToBack(Component component)    {
        int i = getComponentIndex(component);
        if(i != -1){
            add(component);
            return true;
        } else {
        	// was not added
            return false;
        }
    }







    /** tejopa 14.6.2004 */
    
    public void paint(Graphics g) {
	
	
	Out.printMe(Out.TRACE,this.toString());


	DVBGraphicsImpl dvbg = new DVBGraphicsImpl(g);

	paintComponents(dvbg);
	

	}





}

