package org.havi.ui;

import org.openmhp.util.Out;

import java.awt.*;
import org.openmhp.util.LinkedList;

/**
* @author tejopa
* @date 15.2.2004
* @date 11.3.2004 (fixes)
* @status partially implemented
* @module internal, graphics
* @TODO check justifys
* @priority high
*/
public class HDefaultTextLayoutManager implements HTextLayoutManager{

    public HDefaultTextLayoutManager(){
		Out.printMe(Out.TODO);
    }

    public void render(String string, Graphics g, HVisible hVisible, Insets insets){
		//string = "<mhp>"+string;
        int marginTop       = 0;
        int marginBottom    = 0;
        int marginLeft      = 0;
        int marginRight     = 0;

		if (insets!=null) {
        	marginTop       = insets.top;
        	marginBottom    = insets.bottom;
			marginLeft      = insets.left;
        	marginRight     = insets.right;
		}

		LinkedList lines = new LinkedList();
		
		String temp = string;
		
		while (temp.indexOf('\n')!=-1) {
			int i = temp.indexOf('\n');
			String cut = temp.substring(0,i);
			temp = temp.substring(i+1,temp.length());
			lines.add(cut);	
		}
		if (temp.length()>0) { lines.add(temp); }

        
        FontMetrics fontMetrics     = g.getFontMetrics();
        int x                       = 0;
        int y                       = 0;
        int width = hVisible.getWidth();
        int height = hVisible.getHeight();
        int ascent = fontMetrics.getAscent();
        int descent = fontMetrics.getDescent();
        int leading = fontMetrics.getLeading();
        int stringWidth = fontMetrics.stringWidth(string);
        int stringHeight = (ascent + descent + leading);
        
        int textHeight = lines.size() * stringHeight;

        g.setFont(hVisible.getFont());
        g.setColor(hVisible.getForeground());

        for(int lineNumber=0; lineNumber<lines.size(); lineNumber++){
            String currentLine = (String)lines.get(lineNumber);
            stringWidth = fontMetrics.stringWidth(currentLine);

			int startX = 0;
			int startY = 0;
			
			switch (hVisible.getHorizontalAlignment()) {
				case HVisible.HALIGN_CENTER:
					startX = (width/2)-(stringWidth/2); 
					break;
				case HVisible.HALIGN_JUSTIFY: 
					startX = (width/2)-(stringWidth/2); 
					break;
				case HVisible.HALIGN_LEFT: 
					startX = marginLeft;
					break;	
				case HVisible.HALIGN_RIGHT: 
					startX = width-stringWidth-marginRight;
					break;																										
			}

			switch (hVisible.getVerticalAlignment()) {
				case HVisible.VALIGN_CENTER:
					startY = textHeight+((height-stringHeight)/2)-descent+lineNumber*stringHeight; 
					break;
				case HVisible.VALIGN_JUSTIFY: 
					startY = (height-textHeight)/2+lineNumber*stringHeight; 
					break;
				case HVisible.VALIGN_TOP: 
					startY = marginTop+lineNumber*stringHeight;
					break;	
				case HVisible.VALIGN_BOTTOM: 
					startY = height-marginBottom-textHeight+ascent+(lineNumber*stringHeight);
          			break;																										
			}

            g.drawString(currentLine, startX, startY);
        }
    }


}
