package org.havi.ui;

import java.awt.*;
import java.util.Hashtable;

import org.openmhp.util.Out;

/**
* @author tejopa
* @date 5.3.2004
* @status partially implemented
* @module internal
* TODO hinting mechanism
* TODO check default size setting
*/
public class HVisible extends HComponent implements HState{

    public static final int FOCUSED_STATE_BIT = 			0x01;
    public static final int ACTIONED_STATE_BIT = 			0x02;
    public static final int DISABLED_STATE_BIT = 			0x04;
    public static final int FIRST_STATE =					0x80;

    public static final int NORMAL_STATE = 					0x80;
    public static final int FOCUSED_STATE = 				0x81;
    public static final int ACTIONED_STATE = 				0x82;
    public static final int ACTIONED_FOCUSED_STATE = 		0x83;

    public static final int DISABLED_STATE = 				0x84;
    public static final int DISABLED_FOCUSED_STATE = 		0x85;
    public static final int DISABLED_ACTIONED_STATE = 		0x86;
    public static final int DISABLED_ACTIONED_FOCUSED_STATE = 0x87;

    public static final int ALL_STATES = 					0x07;
    public static final int LAST_STATE = 					0x87;

    public static final int HALIGN_LEFT = 		0;
    public static final int HALIGN_CENTER = 	1;
    public static final int HALIGN_RIGHT = 		2;
    public static final int HALIGN_JUSTIFY = 	3;
    public static final int VALIGN_TOP = 		0;
    public static final int VALIGN_CENTER = 	4;
    public static final int VALIGN_BOTTOM = 	8;
    public static final int VALIGN_JUSTIFY = 	12;
    public final static int RESIZE_NONE = 		0;
    public static final int RESIZE_PRESERVE_ASPECT = 	1;
    public static final int RESIZE_ARBITRARY = 			2;
    public static final int NO_BACKGROUND_FILL = 		0;
    public static final int BACKGROUND_FILL = 			1;
    public static final int FIRST_CHANGE = 				0;
    public static final int TEXT_CONTENT_CHANGE = 		0;
    public static final int GRAPHIC_CONTENT_CHANGE = 	1;
    public static final int ANIMATE_CONTENT_CHANGE = 	2;
    public static final int CONTENT_CHANGE = 			3;
    public static final int STATE_CHANGE = 				4;
    public static final int CARET_POSITION_CHANGE = 	5;
    public static final int ECHO_CHAR_CHANGE = 			6;
    public static final int EDIT_MODE_CHANGE = 			7;
    public static final int MIN_MAX_CHANGE = 			8;
    public static final int THUMB_OFFSETS_CHANGE = 		9;
    public static final int ADJUSTMENT_VALUE_CHANGE = 	13;
    public static final int ORIENTATION_CHANGE = 		10;
    public static final int TEXT_VALUE_CHANGE = 		11;
    public static final int ITEM_VALUE_CHANGE = 		12;
    public static final int LIST_CONTENT_CHANGE = 		14;
    public static final int LIST_ICONSIZE_CHANGE = 		15;
    public static final int LIST_LABELSIZE_CHANGE = 	16;
    public static final int LIST_MULTISELECTION_CHANGE = 17;
    public static final int LIST_SCROLLPOSITION_CHANGE = 18;
    public static final int SIZE_CHANGE = 				19;
    public static final int BORDER_CHANGE = 			20;
    public static final int REPEAT_COUNT_CHANGE = 		21;
    public static final int ANIMATION_POSITION_CHANGE = 22;
    public static final int LIST_SELECTION_CHANGE = 	23;
    public static final int UNKNOWN_CHANGE = 			24;
    public static final int LAST_CHANGE = UNKNOWN_CHANGE;
    public static final int NO_DEFAULT_WIDTH = 			-1;
    public static final int NO_DEFAULT_HEIGHT = 		-1;

    protected HLook hLook;
    private int currentState;
    private int backgroundMode;
	private Object[] animateContent;
	private Object[] content;
	private Object[] graphicContent;
	private Object[] textContent;

	private Hashtable lookData;

    private Dimension defaultSize;
    private HTextLayoutManager hTextLayoutManager;

	private boolean focusTraversable = false;

    private int horizontalAlignment = HALIGN_CENTER;
    private int verticalAlignment = VALIGN_CENTER;
    private int resizeMode;


    public static final java.awt.Dimension NO_DEFAULT_SIZE = new java.awt.Dimension(NO_DEFAULT_WIDTH,NO_DEFAULT_HEIGHT);

    public HVisible(){
        this(null, 0, 0, 0, 0);
    }

    public HVisible(HLook hlook){
        this(hlook, 0, 0, 0, 0);
    }

	/**
	* TODO: Default value setting is not yet logical.
	*/
    public HVisible(HLook hlook, int x, int y, int width, int height){

		setDefaults();
		setFont(new Font("Tiresias",Font.PLAIN, 24));
        setDefaultSize(new Dimension(width, height));

		if (hlook!=null) {
	        try { setLook(hlook); } catch (Exception e) { Out.printMe(Out.ERROR,e.toString()); }
			}	

		backgroundMode         = HVisible.NO_BACKGROUND_FILL;
        horizontalAlignment    = HVisible.HALIGN_CENTER;
        verticalAlignment      = HVisible.VALIGN_CENTER;
		resizeMode             = HVisible.RESIZE_NONE;

        hTextLayoutManager     = new HDefaultTextLayoutManager();

        animateContent			= new Object[8];
        content					= new Object[8];
        graphicContent			= new Object[8];
        textContent				= new Object[8];

		lookData = new Hashtable();

        setInteractionState(HVisible.NORMAL_STATE);

        setLocation(x,y);
        setSize(width,height);

		fireWidgetChanged(null);
    }

	/**
	* Set default values, sometimes needs to be overrided by subclass.
	*/
	private void setDefaults() {
		setLocation(0,0);
		setSize(0,0);
		//setGraphicContent(null,NORMAL_STATE);
		//try { setMatte(null); } catch (Exception e) { Out.printMe(Out.ERROR,e.toString()); }
		setTextLayoutManager(new HDefaultTextLayoutManager());
		setBackgroundMode(NO_BACKGROUND_FILL);
		setDefaultSize(NO_DEFAULT_SIZE);
		setHorizontalAlignment(HALIGN_CENTER);
		setVerticalAlignment(VALIGN_CENTER);		
		setResizeMode(RESIZE_NONE);
	}

	//* TEST BITS *//
 	private void testBits(int state) {
 		if(state == FOCUSED_STATE_BIT || state == ACTIONED_STATE_BIT || state == DISABLED_STATE_BIT) {
            throw new java.lang.IllegalArgumentException("HState.XXX_STATE_BIT is not allowed, use HState.XXX_STATE instead.");
        }
    }

    //* HINTING MECHANISM *//
	private void fireWidgetChanged(HChangeData[] hints){
        if(hLook != null) { hLook.widgetChanged(this, hints); }
    }

    /* set to all states */
    protected void setGraphicToAllStates(Image image) {
    	for (int i=0;i<graphicContent.length;i++) {
    		graphicContent[i] = image;
    	}
    }

    /* set to all states */
    protected void setTextToAllStates(String text) {
    	for (int i=0;i<textContent.length;i++) {
    		textContent[i] = text;
    	}
    }

    public Image[] getAnimateContent(int state){
		testBits(state);
		return (Image[])animateContent[state-NORMAL_STATE];
    }

    public int getBackgroundMode(){
        return backgroundMode;
    }

    public Object getContent(int state){
		testBits(state);
		return content[state-NORMAL_STATE];
    }

    public java.awt.Dimension getDefaultSize(){
        return defaultSize;
    }

    public Image getGraphicContent(int state){
		testBits(state);
		return (Image)graphicContent[state-NORMAL_STATE];
    }

    public int getHorizontalAlignment(){
        return horizontalAlignment;
    }

    public int getInteractionState(){
        return currentState;
    }

	public HLook getLook(){
        return hLook;
    }

    public java.lang.Object getLookData(java.lang.Object key){
		return lookData.get(key);
    }

    public Dimension getMaximumSize(){
        Dimension result = null;
        if(hLook != null){
            result = hLook.getMaximumSize(this);
        }
        else {
            result = getSize();
        }
        return result;
    }

    public Dimension getMinimumSize(){
        Dimension result = null;
        if(hLook != null){
            result = hLook.getMinimumSize(this);
        }
        else{
            result = getSize();
        }
        return result;
    }

    public Dimension getPreferredSize(){
        Dimension result = null;
        if(hLook != null){
            Out.printMe(Out.TRACE,"hLook was found");
            result = hLook.getPreferredSize(this);
        }
        else{
			Out.printMe(Out.TRACE,"hLook was not found, returning this.getSize() "+this.getSize().toString());        	
            result = this.getSize();
        }
        return result;
    }

    public int getResizeMode(){
        return resizeMode;
    }

    public String getTextContent(int state){
        testBits(state);
		return (String)textContent[state-NORMAL_STATE];
    }

    public HTextLayoutManager getTextLayoutManager(){
        return hTextLayoutManager;
    }

    public int getVerticalAlignment(){
        return verticalAlignment;
    }

    public boolean isFocusTraversable(){
        return focusTraversable;
    }

    public boolean isOpaque(){
		if (hLook==null) {
			return false;
		}
		else {
			return hLook.isOpaque(this);
		}
    }

    public void paint(Graphics g){
        if (hLook!=null) {
            hLook.showLook(g, this, getInteractionState());
        }
        if (hLook==null) {
			Out.printMe(Out.TRACE,"hLook was null");
        }        
    }

    public void setAnimateContent(Image[] imageArray, int state){
        testBits(state);
        animateContent[state-NORMAL_STATE] = imageArray;
		fireWidgetChanged(null); // should do repaint
    }

    public void setBackgroundMode(int mode){
		if (mode==NO_BACKGROUND_FILL||mode==BACKGROUND_FILL) {
			backgroundMode = mode;
			Out.printMe(Out.TRACE,"set to: "+mode);
		}
    }

    public void setContent(Object object, int state){
        testBits(state);
        content[state-NORMAL_STATE] = object;
        fireWidgetChanged(null);
    }

    public void setDefaultSize(Dimension size){
        defaultSize = size;
    }

    public void setGraphicContent(Image image, int state){
        testBits(state);
        graphicContent[state-NORMAL_STATE] = image;
        fireWidgetChanged(null);
	}

    public void setHorizontalAlignment(int halign){
		if (halign==HALIGN_LEFT||halign==HALIGN_CENTER||halign==HALIGN_RIGHT||halign==HALIGN_JUSTIFY) {
		   horizontalAlignment = halign;
		}
    }

    protected void setInteractionState(int state) throws java.lang.IllegalArgumentException{
		testBits(state);
		currentState = state;
        fireWidgetChanged(null);
    }

    public void setLook(HLook hlook) throws HInvalidLookException{
        hLook = hlook;
        fireWidgetChanged(null);
    }

    public void setLookData(java.lang.Object key, java.lang.Object data){
		lookData.put(key,data);
    }

    public void setResizeMode(int resize){
		if (resize==RESIZE_NONE||resize==RESIZE_PRESERVE_ASPECT||resize==RESIZE_ARBITRARY) {
    		resizeMode = resize;
    	}
    }

    public void setTextContent(String string, int state){
        testBits(state);
        if (state==ALL_STATES) {
        	setTextToAllStates(string);
        	return;
        }
        textContent[state-NORMAL_STATE] = string;
        fireWidgetChanged(null); // should do repaint
    }

    public void setTextLayoutManager(HTextLayoutManager manager){
        hTextLayoutManager = manager;
    }

    public void setVerticalAlignment(int valign){
		if (valign==VALIGN_TOP||valign==VALIGN_CENTER||valign==VALIGN_BOTTOM||valign==VALIGN_JUSTIFY) {
			verticalAlignment = valign;
		}
    }

    public void update(java.awt.Graphics g){
        g.setColor(getBackground());
        paint(g);
    }

}
