package org.havi.ui.event;

import java.awt.*;
import org.openmhp.adaptation.event.*;
import org.openmhp.util.Out;


/**
* @author tejopa
* @date 12.2.2004
* @date 5.4.2004 mapped to adaptation layer
* @status fully implemented
* @module internal, org.openmhp.adaptation.event
* @priority low
* @TODO define capabilities in device configuration or similar
* @NOTE uses org.openmhp.adaptation.event.HEventCapabilites to determine if event is supported
*/
public class HEventRepresentation {

    public static final int ER_TYPE_NOT_SUPPORTED = 0;
    public static final int ER_TYPE_STRING = 1;
    public static final int ER_TYPE_COLOR = 2;
    public static final int ER_TYPE_SYMBOL = 4;

	private Color color = null;
	private int type = -1;
	private String string = "not defined";
	private Image symbol = null;


	protected HEventRepresentation(){
		Out.printMe(Out.TRACE);
    }

	/** tejopa 5.4.2004 */
    public boolean isSupported() {
	    return HEventCapabilities.getInstance().isSupported(this);
    }
    
	/** tejopa 5.4.2004 */
    protected void setType(int aType){
		type = aType;
		Out.printMe(Out.TRACE);
    }

	/** tejopa 5.4.2004 */
    public int getType(){
		Out.printMe(Out.TRACE);
	    return type;
    }

	/** tejopa 5.4.2004 */
    protected void setColor(java.awt.Color aColor){
		color = aColor;
		Out.printMe(Out.TRACE);
    }
    
	/** tejopa 5.4.2004 */
    public Color getColor(){
		Out.printMe(Out.TRACE);
	    return color;
    }

	/** tejopa 5.4.2004 */
    protected void setString(String aText){
		string = aText;
		Out.printMe(Out.TRACE);
    }
    
	/** tejopa 5.4.2004 */
    public String getString(){
		Out.printMe(Out.TRACE);
	    return string;
    }

	/** tejopa 5.4.2004 */
    protected void setSymbol(java.awt.Image aSymbol){
		symbol = aSymbol;
		Out.printMe(Out.TRACE);
    }

	/** tejopa 5.4.2004 */
    public Image getSymbol(){
		Out.printMe(Out.TRACE);
	    return symbol;
    }
}
