package org.openmhp.adaptation.event;

import org.openmhp.application.AppsDatabaseImpl;
import java.net.*;
import java.io.*;
import java.util.*;
import org.openmhp.util.Out;
import java.awt.event.*;

public class EventServer implements Runnable {

	private String ip = "";
	public static  final int SERVER_PORT = 51235;
	private Thread serverThread;
	private static EventServer instance;
	private boolean stopRequested = false;
	private ServerSocket serverSocket;
	
	private static EventServer eventServer;
	
	private Vector eventHandlers;
	
	protected EventServer(String i) {
		ip = i;
		eventHandlers = new Vector();
		serverThread = new Thread(this);
		serverThread.start();
	}

	/** Get instance */
	public static EventServer getInstance(String ip) {
		Out.printMe(Out.TRACE);
	
		if (instance==null) { instance = new EventServer(ip); }
		else { 
			Out.printMe(Out.ERROR,"AppsDatabaseServer already created. Can not start other instances");
		}
		return instance;
	}

	public void sendEvent(KeyEvent e) {
		Enumeration enum = eventHandlers.elements();
		while (enum.hasMoreElements()) {
			EventHandler eh = (EventHandler)enum.nextElement();
			eh.sendEvent(e);
		}	
	}

	public void stop() {
		stopRequested = true;	
	}
	
	public void run() {
		boolean serverStartFailed = false;
		try {
			Out.println(this,"Trying to create EventServer...");
			serverSocket = new ServerSocket(SERVER_PORT);
			Out.println(this,"Yes. Server is running.");
		}
		catch (IOException e) {
			Out.error(this,"Server did NOT start. Reason: "+e.toString());
			serverStartFailed = true;
		}
	
		if (!serverStartFailed) {
				while (!stopRequested) {
				try {	
					Out.println(this,"waiting for connection...");
					eventHandlers.add(new EventHandler(serverSocket.accept()));	
				}
					catch (IOException e) {	Out.error(this,"Failed to create socket! Reason: "+e.toString());			}
				try {	Thread.currentThread().sleep(200);	}
					catch (Exception e) { Out.error(this,e.toString()); }
			}
		}
	}
	
}