package org.openmhp.adaptation.graphics;

import java.net.*;
import java.io.*;
import org.openmhp.util.*;

class GraphicsPipe implements Runnable {
		Socket socket;
		boolean error = false;
		GraphicsOutput graphicsOutput;
		
		public GraphicsPipe(Socket s, GraphicsOutput p) {	
			socket = s;
			graphicsOutput = p;
			new Thread(this).start();
		}
		public void run() {
			//ObjectOutputStream oos = null;
			ObjectInputStream ois = null;
			try {
				//oos = new ObjectOutputStream(socket.getOutputStream());	
				ois = new ObjectInputStream(socket.getInputStream());	
			}
			catch (Exception e) {
				Out.printMe(Out.ERROR,"Error in creating object input stream "+e.toString());				
				error = true;
			}
			while (!error) {
				try {
					graphicsOutput.setOutputObject(ois.readObject());

				}
				catch (Exception e2) {
					if (!(e2 instanceof EOFException)) {
					Out.printMe(Out.ERROR,"Error in reading object from stream: "+e2.toString());				
					}
					error = true;
				}
			}
			System.out.println("GraphicsPipe dies...");
		}
	

	
	
}