package org.openmhp.adaptation.havi;

import org.openmhp.util.Out;
import java.io.*;
import javax.media.*;
import java.net.*;

/**
* @author tejopa
* @date 5.3.2004
* @date 14.4.2004 partially implemented
* @status partially implemented
* @module internal, audio
*/
public class HSoundImpl extends java.lang.Object implements ControllerListener {

	static Player player = null;


	boolean realized = false;
	boolean playing = false;
	boolean loop = false;
	final String TEMP_SOUND = "temp_hsound.mp2";

	public HSoundImpl(){
		Out.printMe(Out.TRACE);     
    }
    
    public void load(String location) throws java.io.IOException, java.lang.SecurityException{
		Out.printMe(Out.TRACE,"load(String location)");
		dispose(); 

		String mediafile = "";
		File file = new File(location);
		if (file!=null) {
			try {
				mediafile = file.getAbsolutePath();
				System.out.println("mediafile: "+mediafile);
			}
			catch (Exception e) {
				System.out.println(e);
			}
		}
		else {
			return;
		}

		load(new URL("file:\\\\\\"+mediafile));

		/*
		player = null;
		realized = false;
		try {
			player = Manager.createPlayer(new URL("file:\\\\\\"+mediafile));
			player.addControllerListener(this);
		}
		catch (Exception e) {

			System.out.println("While creating player: "+e);
			return;
		}

		try {
			player.prefetch();
			player.realize();

		}
		catch (Exception e) {
			System.out.println("While realizing player: "+e);
		}

		while (!realized) {
			try {
				Thread.currentThread().sleep(500);
			}
			catch (Exception e) { }
			System.out.println("waiting for realization...");
		} 
		*/
    }

    public void load(java.net.URL contents) throws java.io.IOException, java.lang.SecurityException{
		Out.printMe(Out.TRACE,"load(URL "+contents.toString()+")"); 
		
		dispose();

		player = null;
		realized = false;
		try {
			player = Manager.createPlayer(contents);
			player.addControllerListener(this);			
		}
		catch (Exception e) {
			System.out.println("While creating player: "+e);
			return;
		}
		try {
			player.prefetch();
			player.realize();
		}
		catch (Exception e) {
			System.out.println("While realizing player: "+e);
		}
		while (!realized) {
			try {
				Thread.currentThread().sleep(500);
			}
			catch (Exception e) { }
			System.out.println("waiting for realization...");
		}		
    }

    public void set(byte[] data){
		Out.printMe(Out.TRACE);   
		stop();
		saveBytes(data);
		try {
			load(org.openmhp.system.Constants.ROOT+File.separator+TEMP_SOUND);
		}
		catch (Exception e) {
			System.out.println(e);
		}
 	
    }

    public void play(){
		Out.printMe(Out.TRACE);     	
		if (player!=null) {
			Out.printMe(Out.TRACE,"player was not null"); 
			player.setMediaTime(new Time(0));
			player.start();
			playing = true;
			loop = false;
		}
		
    }

    public void stop(){
    	Out.printMe(Out.TRACE);     	
		if (player!=null) {
			player.stop();
			playing = false;
			player.setMediaTime(new Time(0));
		}

    }

    public void loop(){
		Out.printMe(Out.TRACE);
		loop = true;
		play();   	
    }

    public void dispose(){
		Out.printMe(Out.TODO,"does only stop now");
		stop();     	
    }

	private void endOfMedia() {
		if (loop) {
			player.setMediaTime(new Time(0));
			play();	
		}
	}		


	private void printState(Player p) {
		switch (p.getState()) {
			case Controller.Prefetched:	System.out.println("Prefetched");
			case Controller.Prefetching: System.out.println("Prefetching");
			case Controller.Realized: System.out.println("Realized");
			case Controller.Started: System.out.println("Started");
			case Controller.Unrealized: System.out.println("Unrealized");

		}
	}		    

	/** Notices when file ends */
	public void controllerUpdate(ControllerEvent event) {
		Out.printMe(Out.TRACE,event.toString()); 
		if (event instanceof javax.media.EndOfMediaEvent) {
			endOfMedia();
		}
		if (event instanceof javax.media.RealizeCompleteEvent) {
			realized = true;
			System.out.println("Realized!");
		}
	}

	/* save bytes */
	public boolean saveBytes(byte[] byteArray) {
		RandomAccessFile fileout = null;
		try {
			String filename = org.openmhp.system.Constants.ROOT+File.separator+TEMP_SOUND;
			
			File temp = new File(filename);
			if (temp.exists()) {
				temp.delete();
			}
						
			fileout = new RandomAccessFile(filename,"rw");
			if (new File(filename).exists()) {
				fileout.write(byteArray,0,byteArray.length);
				fileout.setLength(byteArray.length);
				return true;
			}
			else {
				return false;
			}

		}
		catch (Exception e) { return false; }
	}
    
    
}
