package org.openmhp.application;

import javax.tv.xlet.*;

import org.dvb.application.*;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.io.*;
import java.net.*;

import org.openmhp.system.*;

import org.openmhp.util.Out;

/**
*
* tejopa 19.4.2003
*/
public class AppsDatabaseImpl extends AppsDatabase implements AppStateChangeEventListener {

    private static AppsDatabaseImpl database = null;

	private static Vector appAttributesVec;
	private static Vector appProxysVec;
	private static Vector appsDatabaseEventListenersVec;
	private static AppsDatabaseImpl instance;
	private static boolean remoteDatabaseLoaded = false;




    protected AppsDatabaseImpl(boolean server) {
		super();
		appAttributesVec = new Vector();
		appProxysVec = new Vector();
		appsDatabaseEventListenersVec = new Vector();

		if (server) {

			org.openmhp.system.ProjectHandler handler = new org.openmhp.system.ProjectHandler(System.getProperty("base_dir")+File.separator+System.getProperty("project_dir"));
    	    Project[] projectArray = handler.getProjects();

	        //ProjectParser projectparser = new ProjectParser();
    	    //Vector projects = projectparser.getProjects();
			createDatabase(projectArray);
		}

	}




	/** This will only work when creating server instance */
	private void createDatabase(Project[] projects) {
		Out.printMe(Out.TRACE);
		//Enumeration enum = projects.elements();
		//while (enum.hasMoreElements()) {
		for (int i=0;i<projects.length;i++) {
			Project p = projects[i];
			int oid = Integer.valueOf(p.getOrgId()).intValue();
			int aid = Integer.valueOf(p.getAppId()).intValue();
			String name = p.getXletClass();
			AppID appid = new AppID(oid,aid);
			AppAttributesImpl appatt = new AppAttributesImpl(appid,name);
			appatt.setClasspath(p.getPath());
			appatt.setInitialClass(p.getXletClass());
			appatt.setClassloader(p.classloader);
			//System.out.println("&&& "+p.getPath()+" "+p.getXletClass());
			AppProxyImpl appprx = new AppProxyImpl(appatt);
			appprx.addAppStateChangeEventListener(this);
			appAttributesVec.add(appatt);
			appProxysVec.add(appprx);
		}
	}




	/** Server creates the actual instance of the database */
	public static AppsDatabaseImpl getServerInstance() {
		Out.println(new Object(),"AppsDatabaseImpl getServerInstance");
		if (database==null) database = new AppsDatabaseImpl(true);
		Out.println(new Object(),"AppsDatabaseImpl getServerInstance DONE");
		return database;
	}



	/** Clients request the information from the server */
	public static AppsDatabaseImpl getInstance() {
		// CREATE EMPTY DATABASE
		if (database == null) { database = new AppsDatabaseImpl(false); }
		// LOAD CONTENTS FROM SERVER
		Out.println(new Object(),"AppsDatabaseImpl getInstance");
		if (!remoteDatabaseLoaded) {
			try { loadRemoteDatabase();	}
			catch (Exception e) { Out.error(new Object(),"AppsDatabaseImpl: Error in loading the remote database "+e.toString());}
		}
		return database ;
	}


	private static void loadRemoteDatabase() {
		Out.printMe(Out.TRACE);
		//Out.println(new Object(),"AppsDatabaseImpl loadRemoteDatabase trying to load remote database");
		ADBRequest request = new ADBRequest(ADBRequest.DATABASE_REQUEST,null);
		ADBRequest response = null;
		try {
			Out.println(new Object(),"TRYING CONNECT TO:"+"localhost:"+AppsDatabaseServer.SERVER_PORT);
			Socket s = new Socket("localhost",AppsDatabaseServer.SERVER_PORT);
			ObjectOutputStream ous = new ObjectOutputStream(s.getOutputStream());
			ObjectInputStream ois = new ObjectInputStream(s.getInputStream());
			ous.writeObject(request);
			ous.flush();
			response = (ADBRequest)ois.readObject();
			Out.println(new Object(),"AppsDatabaseImpl loadRemoteDatabase got:"+response.toString());
			ois.close();
			ous.close();
			s.close();
			Out.println(new Object(),"AppsDatabaseImpl loadRemoteDatabase DONE");
		}
		catch (Exception e) {
			Out.error(new Object(),"loadRemoteDatabase got: "+e.toString());
		}
		if (response!=null) {
			constructDatabase((Vector)response.getData());
		}
	}

	public void addListener(AppsDatabaseEventListener appsDatabaseEventListener) {
		Out.println(this,"addListener");
		appsDatabaseEventListenersVec.add(appsDatabaseEventListener);
	}


	/*
	23.2.2005 tejopa
	Removed hexkey check
	*/
    public AppAttributes getAppAttributes(AppID key) {
		Out.println(this,"requested appAttributes with key: "+key);
		//Out.println(this,"Searching also after to HEX conversion.... FIXME ");
		//AppID hexkey = new AppID(Integer.parseInt(Integer.toHexString(key.getOID())),Integer.parseInt(Integer.toHexString(key.getAID())));
        //Out.println(this,"HEXkey: "+hexkey);
        AppAttributes result = null;
        Enumeration e = appAttributesVec.elements();
        while ((result==null)&(e.hasMoreElements())) {
			AppAttributes a = (AppAttributes)e.nextElement();
			if (a.getIdentifier().equals(key)) { result = a; }
			//if (a.getIdentifier().equals(hexkey)) { result = a; }
		}
		Out.println(this,"and returns: "+result);
        return result;
    }



    public Enumeration getAppAttributes(AppsDatabaseFilter filter) {
        Out.println(this,"getAppAttributes with filter NO FILTER USED, size: "+appAttributesVec.size());
        return appAttributesVec.elements();
    }



    public Enumeration getAppIDs(AppsDatabaseFilter filter) {
        Out.println(this,"getAppIDs : returns null");
        return null;
    }



    public AppProxy getAppProxy(AppID key) {
        Out.println(this,"getAppProxy with key "+key.toString());

        AppProxyImpl result = null;

        Enumeration e = appProxysVec.elements();
        while ((result==null)&&(e.hasMoreElements())) {
			AppProxyImpl a = (AppProxyImpl)e.nextElement();
			if (a.getIdentifier().equals(key)) {
				result = (AppProxyImpl)a;
			}
		}
		//if (result!=null) System.out.println(result.getIdentifier());
        return result;
    }



    public void removeListener(AppsDatabaseEventListener appsDatabaseEventListener) {
	    appsDatabaseEventListenersVec.remove(appsDatabaseEventListener);
    }



    public int size() {
        return appProxysVec.size();
    }



	public static Properties loadProperties(String filename) {
		Properties p = new Properties();
		FileInputStream fis = null;
		try {
			fis = new FileInputStream(filename);
			try {	p.load(fis);	}
			catch (IOException e) {
				System.out.println(e.toString());
				}
			}
		catch (Exception e) {
			System.out.println("Error while loading properties file >"+filename+"< "+e.toString());
			}
		System.out.println("Properties file >"+filename+"< loaded.");
		return p;
	}



	/*
	public void changeState(AppCommEvent event) {

		AppID appid = new AppID(event.getOID(),event.getAID());
		AppProxy ap = getAppProxy(appid);
		System.out.println(ap);
		int tostate = -1;
		if (event.getToState()==AppProxy.PAUSED) {
			tostate = AppProxy.PAUSED;
		}
		if (event.getToState()==AppProxy.STARTED) {
			tostate = AppProxy.STARTED;
		}
		if (event.getToState()==AppProxy.DESTROYED) {
			tostate = AppProxy.DESTROYED;
		}
		((AppProxyImplementation)ap).setState(tostate);
		stateChange(new AppStateChangeEvent(appid,event.getFromState(),tostate,this,true));
	}
	*/

	public void stateChange(AppStateChangeEvent event) {
		/*
		Enumeration e = appsDatabaseEventListenersVec.elements();
        while (e.hasMoreElements()) {
			AppsDatabaseEventListener el = (AppsDatabaseEventListener)e.nextElement();
			el.entryChanged(new AppsDatabaseEvent(AppsDatabaseEvent.APP_CHANGED,event.getAppID(),this));
		}
		*/
	}


	/**
	* Server sends this data to the client. Client reconstructs its own
	* version of database with this information.
	*/
	public static Vector getData() {
		Out.printMe(Out.TRACE,""+appProxysVec.size());
		Vector result = new Vector();
		Enumeration e = appProxysVec.elements();
		while (e.hasMoreElements()) {
			AppProxyImpl temp = (AppProxyImpl)e.nextElement();
			result.addElement(new SerializedAppdata(temp));
		}
		Out.printMe(Out.TRACE,"size : "+result.size());
		return result;
	}

	/** Contruct database from Vector of SerializedAppdata. */
	public static void constructDatabase(Vector v) {
		Out.printMe(Out.TRACE);
		Enumeration e = v.elements();
		// remove earlier downloaded apps
		appProxysVec.clear();
		appAttributesVec.clear();

		while (e.hasMoreElements()) {

			SerializedAppdata a = (SerializedAppdata)e.nextElement();

			int oid = a.getOID();
			int aid = a.getAID();
			String name = a.getName();
			AppID appid = new AppID(oid,aid);
			AppAttributesImpl appatt = new AppAttributesImpl(appid,name);
			appatt.setInitialClass(a.getInitialClass());
			appatt.setClasspath(a.getClasspath());
			appatt.setClassloader(a.getClassloader());
			AppProxyImpl appprx = new AppProxyImpl(appatt);
			appAttributesVec.add(appatt);
			appProxysVec.add(appprx);
			//System.out.println("oid: "+oid+" aid: "+aid+" "+name);
		}

	}

/*

	public static void launchXlet(int oid, int aid) {
		Project p = null;
		for (int i=0;i<currentProjects.length;i++) {
			if ((new Integer(currentProjects[i].getOrgId()).intValue()==oid) &(new Integer(currentProjects[i].getAppId()).intValue()==aid)) {
				p = currentProjects[i];
				i=currentProjects.length+1;
			}
		}

		if (p!=null)	{
			System.out.println("launching...");
			new org.openmhp.system.Shell(new String[]{ p.getPath(),p.getXletClass(), p.getOrgId(), p.getAppId()});

			try { Thread.currentThread().sleep(1000); } catch (Exception r) { }
			Exception e = org.openmhp.system.Shell.getException();
			if (e!=null) {
				//JOptionPane.showMessageDialog(this, "Project "+p.getProjectName()+" could not be started. Reason: \n"+e);
			}
		}
	}

*/




}
