package org.openmhp.system;

import java.io.File;

/**
* Project
*/
public class Project{

	public String projectName;
    public String xletClass;
	public String path;
    public String orgid = "0";
    public String appid = "0";
	public String projectFile;
	
	/* outputs on / off */
	public boolean trace = true;
	public boolean debug = true;
	public boolean fixme = true;
	public boolean todo = true;
	public boolean error = true;
	public boolean classloader = true;	
	
	public boolean subtitles = false;

	public Project() { }

    public Project(String projectName, String path, String xletName, String org, String app){
        this.projectName = projectName;        
        this.xletClass = xletName;
        this.orgid = org;
        this.appid = app;
        if(path.lastIndexOf(File.separator) > -1 && path.lastIndexOf(File.separator) == path.length()-1){
            path = path.substring(0, path.length()-1);
        }
        this.path = path;
    }

    public String getProjectName(){
        return projectName;
    }

    public String getPath(){
        return path;
    }

    public String getXletClass(){
        return xletClass;
    }

    public String getOrgId(){
        return orgid;
    }

    public String getAppId(){
        return appid;
    }    

	public String toString() {
		String result = projectName+"\n"+xletClass+"\n"+path+"\n"+orgid+"\n"+appid+"\n";
		result+=new Boolean(trace).toString()+"\n";
		result+=new Boolean(debug).toString()+"\n";
		result+=new Boolean(fixme).toString()+"\n";
		result+=new Boolean(todo).toString()+"\n";
		result+=new Boolean(error).toString()+"\n";
		result+=new Boolean(classloader).toString()+"\n";
		result+=new Boolean(subtitles).toString()+"\n";	
		return result;
	}
	
}
