package org.openmhp.xlet;

import javax.tv.xlet.Xlet;
import javax.tv.xlet.XletContext;

import org.openmhp.util.Out;
import org.openmhp.system.*;

/**
* @author tejopa
* @date 17.3.2004
* @status partially implemented
* @module internal
*/
public class XletContextImpl implements XletContext {

    public static final int INITIALIZED = 0;
    public static final int STARTED = 2;
    public static final int PAUSED = 3;
    public static final int DESTROYED = -1;
    private int state;
    private XletManager manager;
    private Xlet xlet;

    public XletContextImpl(XletManager xletmanager, Xlet a_xlet)    {
        manager = xletmanager;
        xlet = a_xlet;
    }

    public Object getXletProperty(String key)    {
        Out.printMe(Out.TRACE, "getXletProperty(" + key + ")");
        
        if(key.equals("javax.tv.xlet.container")) {
        	return org.openmhp.system.MHPDevice.getInstance().getGraphicsLayer();
       	}
       
        if(key.equals("javax.tv.xlet.service_context")) {
        	System.out.println("getXletProperty returning ServiceContextImpl.getInstance()");
        	return org.openmhp.service.ServiceContextImpl.getInstance();
        }

		if (key=="dvb.caller.parameters") {
			Out.println(this,"returning new String[0]");
			return new String[0];
		}
		if (key.indexOf("dvb.app.id")!=-1) {
			Out.println(this,"is returning "+manager.getAppID().getAID());
			return ""+manager.getAppID().getAID();
		}
		if (key.indexOf("dvb.org.id")!=-1) {
			System.out.println(manager.toString());
						
			Out.println(this,"returning "+manager.getAppID().getOID());
			return ""+manager.getAppID().getOID();
		}
		if (key==XletContext.ARGS) {
			Out.println(this,"returning new String[0]");
			return new String[0];
		}

		return null;

    }


    public void notifyDestroyed()    { Out.println(this,"notifyDestroyed"); }

    public void notifyPaused()    { Out.println(this,"notifyPaused"); }

    public void resumeRequest()    { Out.println(this,"resumeRequest"); }

    public int getState()    {
    	Out.println(this,"getState");
        return state;
	}

    public void setState(int i)    {
    	Out.println(this,"setState "+i);
        switch (i) {
        	case INITIALIZED: Out.println(this,"INITIALIZED");
        	break;	
        	case STARTED: Out.println(this,"STARTED");
        	break;
        	case PAUSED: Out.println(this,"PAUSED");
        	break;
        	case DESTROYED: Out.println(this,"DESTROYED");
        	break;
        }
        state = i;
    }




}