package org.dvb.application.storage;

/**
 * <p>
 * This class represents a permission to manage applications
 * stored in the MHP terminal. An ApplicationStoragePermission contains 
 * a name representing the organisation_id whose applications can 
 * be managed and an actions list representing the permitted 
 * actions, i.e. store and/or remove applications.
 * </p>
 * <p>The name of the permission contains the organisation_id 
 * represented in hexadecimal form without any "0x" prefix.
 * When the application possesses this permission, it is able
 * to initiate storage or removal of applications signalled
 * with this organisation_id. If the application does not 
 * have the ApplicationStoragePermission granted with the same 
 * organisation_id as the application is signalled with
 * when it tries to initiate either storing or removal of an 
 * application, the methods to store/remove will throw a
 * SecurityException.
 * </p>
 * <p>The actions string shall be one of the following :-
 * <ul>
 * <li>"store", representing permission to store an application
 * <li>"remove", representing permission to remove an application 
 * <li>"create", representing permission to create a stored application service
 * <li>"remove_service", representing permission to remove a stored application service
 * <li>"*", representing all of the above
 * </ul>
 *
 * @since MHP1.1
 */

public class ApplicationStoragePermission
	extends java.security.BasicPermission
{
    /**
      * Creates a new ApplicationStoragePermission with the specified 
      * name. Permissions created with this constructor implicitly
      * have the actions string set to "*".
      * 
      * @param name the organisation_id whose applications can be 
      *             managed. This is encoded in hexadecimal representation
      *             without any preceding "0x" prefix.
      */
    public ApplicationStoragePermission(String name) {
	super(name);
    }

    /** 
      * Creates a new ApplicationStoragePermission object with the 
      * specified name. The name contains the organisation_id of 
      * the applications that can be managed 
      * and the actions String shall be either "store", "remove"
      * or "*".
      *
      * Permission objects constructed with incorrectly encoded
      * parameters do not represent any permission and are 
      * ignored by the platform.
      *
      * @param name the organisation_id whose applications can be 
      *             managed. This is encoded in hexadecimal representation
      *             without any preceding "0x" prefix.
      * @param actions Shall contain "store", "remove" or "*"
      */
    public ApplicationStoragePermission(String name, String actions) {
	super(name,actions);
    }
}









