import java.awt.*;
import java.awt.event.*;
import javax.tv.xlet.*;
import org.havi.ui.*;
import org.dvb.ui.*;


/**
* Simple Hello world xlet for testing OpenMHP environment.
* @author tejopa
* @date 22.04.2004
*/
public class HelloWorld extends Component implements KeyListener, Xlet {

	private XletContext context;
	private HScene scene;
	private String string = "Hello world!";

	public HelloWorld() {
		super();
	}

	public void initXlet(XletContext ctx) throws XletStateChangeException {
		setName("HelloWorld");
		this.context = ctx;
		HSceneFactory factory = HSceneFactory.getInstance();
		HSceneTemplate hst = new HSceneTemplate();
		hst.setPreference(HSceneTemplate.SCENE_SCREEN_DIMENSION, new org.havi.ui.HScreenDimension(1, 1), HSceneTemplate.REQUIRED);
		hst.setPreference(HSceneTemplate.SCENE_SCREEN_LOCATION, new org.havi.ui.HScreenPoint(0, 0), HSceneTemplate.REQUIRED);

	    scene = factory.getBestScene(hst);

		scene.setBounds(0,0,720,576);
		scene.setLayout(null);

		scene.setBackgroundMode(HScene.BACKGROUND_FILL);
		scene.add(this);

		scene.addKeyListener((KeyListener)this);

		this.setSize(scene.getSize());


	}

	public void startXlet() throws XletStateChangeException {
		validate();
		scene.setVisible(true);
		scene.requestFocus();
	}

	public void pauseXlet() {
		scene.setVisible(false);
	}

	public void destroyXlet(boolean b) {
		if (scene != null) {
			removeKeyListener(this);
			scene.remove(this);
			scene.setVisible(false);
			HSceneFactory.getInstance().dispose(scene);
			scene = null;
		}
		context.notifyDestroyed();
	}

	public void paint(Graphics g) {
   		g.setFont(new Font("Tireasias",Font.PLAIN,56));
		g.setColor(Color.black);
		g.drawString(string,100,100);
		g.setColor(Color.white);
		g.drawString(string,102,102);
		try {
			DVBAlphaComposite.getInstance(DVBAlphaComposite.SRC);
			((DVBGraphics)g).setDVBComposite(DVBAlphaComposite.getInstance(DVBAlphaComposite.SRC));
			}
		catch (Exception e) {
			System.out.println(e);
			}
	}


	public void keyPressed (KeyEvent key) {
		if (key.getKeyCode()==KeyEvent.VK_ENTER) {
			destroyXlet(true);
		}
	}

	public void keyTyped(KeyEvent ignored) {   }

	public void keyReleased(KeyEvent ignored) {   }
}