import java.awt.*;
import java.awt.event.*;
import javax.tv.xlet.*;
import org.havi.ui.*;
import org.dvb.ui.*;


/**
* Simple xlet for demonstrating color functionality in MHP and OpenMHP environment.
* @author tejopa
* @date 22.06.2004
*/
public class ColorDemo extends Container implements KeyListener, Xlet {

	private XletContext context;
	private HScene scene;

	private ColorRect colorRect;

	public ColorDemo() {
		super();
	}

	public void initXlet(XletContext ctx) throws XletStateChangeException {
		setName("ColorDemo");
		this.context = ctx;
		HSceneFactory factory = HSceneFactory.getInstance();
		HSceneTemplate hst = new HSceneTemplate();
		hst.setPreference(HSceneTemplate.SCENE_SCREEN_DIMENSION, new org.havi.ui.HScreenDimension(1, 1), HSceneTemplate.REQUIRED);
		hst.setPreference(HSceneTemplate.SCENE_SCREEN_LOCATION, new org.havi.ui.HScreenPoint(0, 0), HSceneTemplate.REQUIRED);

	    scene = factory.getBestScene(hst);

		scene.setBounds(0,0,720,576);
		scene.setLayout(null);

		scene.setBackgroundMode(HScene.BACKGROUND_FILL);
		scene.add(this);
		
		colorRect = new ColorRect(); 
		this.add(colorRect);

		scene.addKeyListener((KeyListener)this);

		this.setSize(scene.getSize());


	}
 
	public void startXlet() throws XletStateChangeException {
		validate();
		scene.setVisible(true);
		scene.requestFocus();
	}

	public void pauseXlet() {
		scene.setVisible(false);
	}

	public void destroyXlet(boolean b) {
		if (scene != null) {
			removeKeyListener(this);
			scene.remove(this);
			scene.setVisible(false);
			HSceneFactory.getInstance().dispose(scene);
			scene = null;
		}
		context.notifyDestroyed();
	}

	public void keyPressed (KeyEvent key) {
		if (key.getKeyCode()==KeyEvent.VK_ENTER) {
			destroyXlet(true);
		}
		else {
			repaint();	
		}
	}

	public void keyTyped(KeyEvent ignored) {   }

	public void keyReleased(KeyEvent ignored) {   }

	public void paint(Graphics g) {
		colorRect.paint(new DVBGraphicsImpl(g));	
	}

	class ColorRect extends Component {
		public ColorRect() {
			setSize(720,576);
		}
		
		public void paint(Graphics g) {
			
			int edge = 4;
			int w = 70;
			int h = 70;
			int x_s = (720-(edge*w))/2;
			int y_s = (576-(edge*h))/2;
			
			float b_f = 255/(float)(w*h);
			float b = 0;
			
			int y_p = y_s;
			for (int y=0;y<h;y++) {
				int x_p = x_s; 
				for (int x=0;x<w;x++) {
					g.setColor(new DVBColor(x_p%255,y_p%255,((int)b)%255,255));
					g.fillRect(x_p,y_p,x+edge,y+edge);
					x_p+=edge;
					b+=b_f;
				}
				y_p+=edge;
			}
		}
				
	}
}