package org.davic.mpeg;

import org.openmhp.util.Out;

/**
* @author tejopa
* @date 13.2.2004
* @date 14.11.2004 added docs
* @status partially implemented
* @module internal
*/
public class NotAuthorizedException extends java.lang.Exception implements NotAuthorizedInterface {

	private ElementaryStream[] streams = null;
	private Service service = null;
	private int type = SERVICE;

	/**
	*	Constructs a NotAuthorizedException with no detail message
	*/
	public NotAuthorizedException() {	}

	/**
	*	Constructs a NotAuthorizedException with the specified detail message
	*/
	public NotAuthorizedException(String s) {
		super(s);
	}

	/**
	*	Returns:
	*	SERVICE or ELEMENTARY_STREAM to indicate that either a service (MPEG program) or one or more
	*	elementary streams could not be descrambled.
	*/
	public int getType(){
		return type;
	}

	/**
	*	If getType() returns SERVICE, then this method returns the Service that could not be descrambled. Otherwise it
	*	returns null.
	*	Returns:
	*	either the Service that could not be descrambled or null
	*/
    public Service getService(){
		return service;
    }

	/**
	*	If getType() returns ELEMENTARY_STREAM, then this method
	*	returns the set of ElementaryStreams that could not be
	*	descrambled. Otherwise it returns null.
	*/
    public ElementaryStream[] getElementaryStreams(){
		return streams;
    }

	/**
    Returns the reason(s) why descrambling was not possible.

    Specified by:
        getReason in interface NotAuthorizedInterface

    Parameters:
        index - If the component to which access failed is a Service,
        index shall be 0. Otherwise index shall refer to one stream in
        the set returnedby getElementaryStreams().
    Returns:
        an array of length 2 where the first element of the array is
        the major reason and the second element of the array is the
        minor reason.
    Throws:
        java.lang.IndexOutOfBoundsException - If the component to which
        access failed is a Service, this exception will be thrown if
        index is non zero. If the component(s) to which access failed
        was a (set of) elementary streams then this exception will be
        thrown where index is beyond the size of the array returned
        by getElementaryStreams.
    */
    public int[] getReason(int index) throws java.lang.IndexOutOfBoundsException {
		Out.printMe(Out.TODO,"returns null");
		return null;
    }

	// private

	public void setValues(int t, Service s, ElementaryStream[] es) {
		type = t;
		service = s;
		streams = es;
	}

}










