package org.davic.net.ca;

import org.openmhp.util.Out;

/**
* @author tejopa
* @date 13.2.2004
* @date 14.11.2004 fully implemented
* @status fully implemented
* @module internal

This event informs that a new CA module has been added. In the case of a CA module based on the DVB common interface, this event shall only be generated when module initialisation has been completed. Hence an application has no means to detect when a module is inserted but has not yet been initialised.

*/
public class NewModuleEvent extends CAEvent {

	CAModule camodule;
	Object moduleManager;
	public NewModuleEvent(CAModule caModule, Object caModuleManager) {
		super();
		camodule = caModule;
		moduleManager = caModuleManager;
		Out.printMe(Out.TRACE);
	}

	public CAModule getModule() {
		Out.printMe(Out.TRACE);
		return camodule;
	}

	public Object getSource() {
		Out.printMe(Out.TRACE);
	    return moduleManager;
	}

}
