package org.dvb.media;

import javax.media.StopEvent;
import javax.media.Controller;
import org.openmhp.util.Out;


/**
* @author tejopa
* @date 13.2.2004
* @status partially implemented
* @module internal

Description
This event is generated whenever presentation of a stream stops because there are no selected
components to present. One example of this would be use of the
javax.tv.media.MediaSelectControl.remove method to remove all components of a service.
Generation of this event informs the application that the Player is no longer presenting any content.
Since:
MHP 1.0.1

*/
public class NoComponentSelectedEvent extends StopEvent {

	javax.media.MediaLocator mediastream;

	/**
	Construct an event.
	Parameters:
	source - the controller which was presenting the service
	*/
	public NoComponentSelectedEvent(Controller source){
		super(source,0,0,0,null);
		Out.printMe(Out.TRACE);
	}


	/**
	Construct an event.
	Parameters:
	source - the controller which was presenting the service
	stream - the locator of the stream whose presentation has stopped
	*/
	public NoComponentSelectedEvent(Controller source, javax.media.MediaLocator stream){
		super(source,0,0,0,null);
		mediastream = stream;
		Out.printMe(Out.TRACE);
	}

	/**
	This method returns the stream whose presentation has stopped
	Returns:
	the stream concerned
	*/
	public javax.media.MediaLocator getStream(){
		Out.printMe(Out.TRACE);
		return mediastream;
	}
}


