package org.dvb.media;

import javax.media.StopEvent;
import javax.media.Controller;
import org.openmhp.util.Out;

/**
* @author tejopa
* @date 13.2.2004
* @date 1.12.2004 fix
* @status partially implemented
* @module internal


This event is generated whenever presentation of a stream stops because the player has lost so many
resources that it cannot continue. Generation of this event informs the application that the Player is no
longer presenting any content.
Since:
MHP 1.0.1

*/
public class StopByResourceLossEvent extends StopEvent {

	javax.media.MediaLocator mediastream;

	/**
	Construct an event.
	Parameters:
	source - the controller which was presenting the service
	*/
	public StopByResourceLossEvent(Controller obj){
		super(obj,0,0,0,null);
		Out.printMe(Out.TRACE);
	}

	/**
	Construct an event.
	Parameters:
	source - the controller which was presenting the service
	stream - the locator of the stream which was being presented
	*/
	public StopByResourceLossEvent(Controller obj, javax.media.MediaLocator stream){
		super(obj,0,0,0,null);
		mediastream = stream;
		Out.printMe(Out.TRACE);
	}

	/**
	This method returns the stream which was being presented
	Returns:
	the stream concerned
	*/
	public javax.media.MediaLocator getStream(){
		Out.printMe(Out.TRACE);
		return mediastream;
	}
}


