package org.dvb.media;

import org.havi.ui.HScreenPoint;
import java.awt.*;
import org.openmhp.util.Out;

/**
* @author tejopa
* @date 7.3.2004
* @date 11.3.2004 (changes)
* @status partially  implemented
* @module internal
* @HOME
*/
public class VideoTransformation{

	float scaleX = 1.0f;
	float scaleY = 1.0f;
	Rectangle clipping = new Rectangle(720,576);
	HScreenPoint location = new HScreenPoint(0,0);

	public VideoTransformation(){	
		/*
		Creates a VideoTransformation object with default parameters. Clipping is disabled, both the
		horizontal and the vertical scaling factors are 1, and the video position is (0, 0) in the normalised
		coordinate space.
		*/
		Out.printMe(Out.TRACE);
	}
	
	public VideoTransformation(java.awt.Rectangle clipRect, float horizontalScalingFactor, float verticalScalingFactor, HScreenPoint a_location){
		clipping = clipRect;
		scaleX = horizontalScalingFactor;
		scaleY = verticalScalingFactor;
		location = a_location;
		Out.printMe(Out.TRACE);
	}

	public java.awt.Rectangle getClipRegion(){
		return clipping;
	}

	public float[] getScalingFactors(){
		return new float[]{scaleX,scaleY};
	}

	public HScreenPoint getVideoPosition(){
		return location;
	}

	public boolean isPanAndScan(){
		Out.printMe(Out.TODO);
		return false;
	}

	public void setClipRegion(java.awt.Rectangle clipRect){
		clipping = clipRect;
	}

	public void setScalingFactors(float horizontalScalingFactor, float verticalScalingFactor){
		scaleX = horizontalScalingFactor;
		scaleY = verticalScalingFactor;
	}

	public void setVideoPosition(HScreenPoint loc)	{
		location = loc;
	}

	public String toString() {
		String result = "";
		result+=" x: "+location.x;	
		result+=" y: "+location.y;	
		result+=" xscale: "+scaleX;
		result+=" yscale: "+scaleY;	
		return result;
	}

}
