package org.dvb.ui;

import org.openmhp.util.Out;

/**
* @author tejopa
* @date 7.3.2004
* @status partially implemented
* @module internal
* @HOME
*/
public final class DVBAlphaComposite {
	
	/*

	The following abbreviations are used in the description of the rules:
	Cs = one of the color components of the source pixel without alpha.
	cs = color component of a source pixel premultimlied with alpha (cs = As*Ar*Cs)
	Cd = one of the color components of the destination pixel without alpha.
	cd = color component of a destination pixel premultimlied with alpha
	Cn = the new constructed color without alpha.
	cn = the new constructed color premultiplied with alpha
	As = alpha component of the source pixel.
	Ad = alpha component of the destination pixel.
	An = the new alpha after compositing
	Ar = alpha, specified by getInstance(int Rule, float Ar). Unless otherwise specified Ar = 1.0f
	Fs = fraction of the source pixel that contributes to the output.
	Fd = fraction of the input destination pixel that contributes to the output.
	The color and alpha components produced by the compositing operation are calculated as follows:
	cn = (As*Ar)*Cs*Fs + Ad*Cd*Fd
	An = (As*Ar)*Fs + Ad*Fd
	Cn = cn/An
	where Fs and Fd are speci.ed by each rule.
	The alpha resulting from the compositing operation is stored in the destination if the destination has an
	alpha channel. Otherwise, the resulting color is divided by the resulting alpha before being stored in the
	destination and the alpha is discarded. If the alpha value is 0.0, the color values are set to 0.0.
	
	*/

	public final static int CLEAR = 1;
	public final static int SRC = 2;
	public final static int SRC_OVER = 3;
	public final static int DST_OVER = 4;
	public final static int SRC_IN = 5;
	public final static int DST_IN = 6;
	public final static int SRC_OUT = 7;
	public final static int DST_OUT = 8;

	public static final DVBAlphaComposite Clear	= new DVBAlphaComposite(CLEAR);

	public static final DVBAlphaComposite DstIn	= new DVBAlphaComposite(DST_IN);
	public static final DVBAlphaComposite DstOut	= new DVBAlphaComposite(DST_OUT);
	public static final DVBAlphaComposite DstOver	= new DVBAlphaComposite(DST_OVER);

	public static final DVBAlphaComposite Src	= new DVBAlphaComposite(SRC);
	public static final DVBAlphaComposite SrcIn	= new DVBAlphaComposite(SRC_IN);
	public static final DVBAlphaComposite SrcOut	= new DVBAlphaComposite(SRC_OUT);
	public static final DVBAlphaComposite SrcOver	= new DVBAlphaComposite(SRC_OVER);

	private float currentAlpha;
	private int currentRule;

	public boolean equals(Object obj) {
		if (!(obj instanceof DVBAlphaComposite)) {
			return false;
		}
		DVBAlphaComposite other = (DVBAlphaComposite) obj;
		if (getRule()!=other.getRule()) {
			return false;
		}
		if (getAlpha()!=other.getAlpha()) {
			return false;
		}
		return true;
	}

	public float getAlpha() {
		return currentAlpha;
	}
	
	public static DVBAlphaComposite getInstance(int rule) {
		//Out.printMe(Out.FIXME,"create rules");
		return new DVBAlphaComposite(rule);
	} 
	
	public static DVBAlphaComposite getInstance(int rule, float alpha) {
		//Out.printMe(Out.FIXME,"create rules");
		return new DVBAlphaComposite(rule,alpha);
	} 

	private DVBAlphaComposite(int rule) {
		this(rule, 1.0f);
	}

	private DVBAlphaComposite(int rule, float alpha) {
		if (alpha<0.0f) { alpha = 0.0f; }
		if (alpha>1.0f) { alpha = 1.0f; }
		
		if (rule<CLEAR) { rule = CLEAR; }
		if (rule>DST_OUT) { rule = DST_OUT; }

		currentRule = rule;
		currentAlpha = alpha;
		//Out.printMe(Out.TRACE);
	}

	public int getRule() {
		return currentRule;
	}
}
