package org.dvb.ui;

import org.havi.ui.HVisible;
import java.awt.Insets;

import org.openmhp.util.LinkedList;
import org.openmhp.util.Out;

/**
* @author tejopa
* @date 7.3.2004
* @date 11.3.2004 fix
* @status partially implemented
* @module internal
* TODO text rendering (render()), not so tough, just need to be sharp
* @HOME
*/
public class DVBTextLayoutManager implements org.havi.ui.HTextLayoutManager {

	
	public final static int HORIZONTAL_START_ALIGN = 1;
	public final static int HORIZONTAL_END_ALIGN = 2;
	public final static int HORIZONTAL_CENTER = 3;
	public final static int VERTICAL_START_ALIGN = 4;
	public final static int VERTICAL_END_ALIGN = 5;
	public final static int VERTICAL_CENTER = 6;
	public final static int LINE_ORIENTATION_HORIZONTAL = 10;
	public final static int LINE_ORIENTATION_VERTICAL = 11;
	public final static int START_CORNER_UPPER_LEFT = 20;
	public final static int START_CORNER_UPPER_RIGHT = 21;
	public final static int START_CORNER_LOWER_LEFT = 22;
	public final static int START_CORNER_LOWER_RIGHT = 23;

	private int horizontalAlign = HORIZONTAL_START_ALIGN;
	private int verticalAlign = VERTICAL_START_ALIGN;
	private int lineOrientation = LINE_ORIENTATION_HORIZONTAL;	
	private int startCorner = START_CORNER_UPPER_LEFT;
	private boolean wrap = true;
	private int linespace = 24;
	private int letterspace = 0;
	private int horizontalTabSpace = 56;

	private Insets insets = new Insets(0,0,0,0);

	private LinkedList overflowListeners;
	
	public  DVBTextLayoutManager() {	}

    public  DVBTextLayoutManager(int horizontalAlign, int verticalAlign, int lineOrientation, int startCorner,
				 boolean wrap, int linespace, int letterspace, int horizontalTabSpace) {

		this.horizontalAlign = horizontalAlign;
		this.verticalAlign = verticalAlign;
		this.lineOrientation = lineOrientation;	
		this.wrap = wrap;
		this.linespace = linespace;
		this.letterspace = letterspace;
		this.horizontalTabSpace = horizontalTabSpace;
	}

	public void render(String markedUpString, java.awt.Graphics g, HVisible v, java.awt.Insets insets) {
		Out.printMe(Out.TODO);
	}

    public void setHorizontalAlign(int horizontalAlign) {
		this.horizontalAlign = horizontalAlign;
    }

    public void setVerticalAlign(int verticalAlign) {
		this.verticalAlign = verticalAlign;
    }

    public void setLineOrientation(int lineOrientation) {
		this.lineOrientation = lineOrientation;	
    }

    public void setStartCorner(int startCorner) {
    	this.startCorner = startCorner;
    }

    public void setTextWrapping(boolean wrap) {
    	this.wrap = true;
    }

	public void setLineSpace(int lineSpace) {
		this.linespace = linespace;
    }

    public void setLetterSpace(int letterSpace) {
		this.letterspace = letterspace;
    }

    public void setHorizontalTabSpacing(int horizontalTabSpace) {
		this.horizontalTabSpace = horizontalTabSpace;
    }

    public int getHorizontalAlign() {
		return horizontalAlign;
    }

    public int getVerticalAlign() {
		return verticalAlign;
    }

    public int getLineOrientation() {
		return lineOrientation;
    }

    public int getStartCorner() {
		return startCorner;
    }

    public boolean getTextWrapping() {
		return wrap;
    }

    public int getLineSpace() {
		return linespace;
    }

    public int getLetterSpace() {
		return letterspace;
    }

    public int getHorizontalTabSpacing() {
		return horizontalTabSpace;
    }

    public void setInsets(java.awt.Insets insets) {
		this.insets = insets;
    }

	public java.awt.Insets getInsets() {
        return insets;
    }

    public void addTextOverflowListener(TextOverflowListener l) {
		if (overflowListeners==null) {
			overflowListeners = new LinkedList();
		}
		overflowListeners.add(l);
    }

	public void removeTextOverflowListener(TextOverflowListener l) {
		if (overflowListeners!=null) {
			overflowListeners.remove(l);	
		}
    }

}









