package org.havi.ui;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Enumeration;

import org.openmhp.util.*;

import org.openmhp.system.*;


import org.dvb.ui.*;
import org.dvb.event.*;

import java.net.*;
import java.io.*;
import java.util.zip.*;
import java.awt.image.*;
import javax.imageio.ImageIO.*;
import org.openmhp.adaptation.graphics.*;

import java.util.*;

/**
* @author tejopa
* @date 4.3.2004
* @date 31.5.2004 now paints to DVBGraphics instead of graphics
* @status partially implemented
* @module internal, graphics
*/
public class HScene extends Container implements HComponentOrdering, ImageObserver, MenuContainer, Serializable {

    public static final int IMAGE_NONE = 0;
    public static final int IMAGE_STRETCH = 1;
    public static final int IMAGE_CENTER = 2;
    public static final int IMAGE_TILE = 3;
    public static final int NO_BACKGROUND_FILL = 0;
    public static final int BACKGROUND_FILL = 1;

    private boolean shortCutsEnabled;
    private org.openmhp.util.LinkedList windowListeners;
    private Hashtable shortcuts;
    private Image backgroundImage;
    private int backgroundMode;
    private int renderMode;


    protected HScene()    {
        setLayout(null);
        backgroundMode = NO_BACKGROUND_FILL;
        renderMode = IMAGE_NONE;
        windowListeners = new org.openmhp.util.LinkedList();
    	shortcuts = new Hashtable();
    }

	/** tejopa 4.3.2004 */
    public boolean addShortcut(int i, HActionable comp)    {
	shortcuts.put(new Integer(i),comp);
        return false;
    }

    /** tejopa 4.3.2004 */
    public void addWindowListener(WindowListener wl)    {
        windowListeners.add(wl);
    }

	/** tejopa 4.3.2004 */
    public void dispose()    {
		Out.printMe(Out.TODO);
	}

	/** tejopa 4.3.2004 */
    public void enableShortcuts(boolean b)    {
        shortCutsEnabled = b;
    }

	/** tejopa 4.3.2004 */
    public int[] getAllShortcutKeycodes()    {
        Enumeration keys = shortcuts.keys();
        int[] result = new int[shortcuts.size()];
        int i=0;
        while (keys.hasMoreElements()) {
        	result[i] = ((Integer)keys.nextElement()).intValue();
        }
        return result;
    }

	/** tejopa 4.3.2004 */
    public Image getBackgroundImage()    {
        return backgroundImage;
    }

	/** tejopa 4.3.2004 */
    public int getBackgroundMode()    {
        return backgroundMode;
    }


	/** tejopa 4.3.2004 */
    public Component getFocusOwner() {
    	Component focused = null;
    	Component[] c = getComponents();
    	for (int i=0;i<c.length;i++) {
    		if (c[i].hasFocus()) {
    			focused = c[i];
    		}
    	}
    	return focused;
    }

	/** tejopa 4.3.2004 */
    public HScreenRectangle getPixelCoordinatesHScreenRectangle(Rectangle r)    {
		Out.printMe(Out.TODO);
        return null;
    }

	/** tejopa 4.3.2004 */
    public int getRenderMode()    {
        return renderMode;
    }

	/** tejopa 4.3.2004 */
    public HSceneTemplate getSceneTemplate() {
		Out.printMe(Out.TODO);
        return null;
    }

	/** tejopa 4.3.2004 */
    public HActionable getShortcutComponent(int keyCode)    {
        Enumeration keys = shortcuts.keys();
        HActionable result = null;
        while (keys.hasMoreElements()) {
        	Integer key = (Integer)keys.nextElement();
        	if (key.intValue()==keyCode) {
        		result = (HActionable)shortcuts.get(key);
        	}
        }
        return result;
    }

	/** tejopa 4.3.2004 */
    public int getShortcutKeycode(HActionable comp)    {
        Enumeration keys = shortcuts.keys();
        int result = java.awt.event.KeyEvent.VK_UNDEFINED;
        while (keys.hasMoreElements()) {
        	Integer key = (Integer)keys.nextElement();
        	HActionable action = (HActionable)shortcuts.get(key);
        	if (comp==action) {
        		result = key.intValue();
        	}
        }
        return result;
    }

	/** tejopa 4.3.2004 */
    public boolean isDoubleBuffered()    {
		Out.printMe(Out.FIXME,"returns true");
        return true;
    }

	/** tejopa 4.3.2004 */
    public boolean isEnableShortcuts()    {
        return shortCutsEnabled;
    }


	/** tejopa 4.3.2004 */
    public boolean isOpaque()    {
		Out.printMe(Out.TODO);
        return false;
    }

	/** tejopa 4.3.2004 */
    public boolean isVisible()    {
        return super.isVisible();
    }

	public void setLayout() {
		Out.printMe(Out.TRACE,"#########################################################");
	}
	

    /** tejopa 4.3.2004 */
    /** pcesar 27.9.2004 **/
    public void paint(Graphics g) {
	if (getBackgroundMode()==BACKGROUND_FILL) {
	    Color c = getBackground();
	    //Out.printMe(Out.FIXME,"dont fill with black!! should be null");
	    /* pcesar: The background should not be repainted */
	    //g.fillRect(0,0,getWidth(),getHeight());
	}
	if (getBackgroundImage()!=null) {
	    if (getRenderMode()!=IMAGE_NONE) {
		Out.printMe(Out.FIXME,"now paints only IMAGE_STRETCH");
		g.drawImage(backgroundImage,0,0,getWidth(),getHeight(),null);
	    }
	}

	/* you should remove this call */
	//super.paint(g); 
	
	//Out.printMe(Out.TRACE);
	
	DVBGraphicsImpl dvbg = new DVBGraphicsImpl(g);
	
	/** pcesar: This way the children are painted properly **/
	paintComponents(dvbg);
	
	
	/* pcesar: This is commented because this way the components will always paint in the top left corner of the screen, without taking into account their own properties such as location and size **/
	/* In fact paint of Container is a little more complicated than that */

	/**
	   Component[] c = getComponents(); // get all child components
	   for (int i=0;i<c.length;i++) {
	   System.out.println(c[i].toString());
	   //Graphics dvbg = c[i].getGraphics();
	   c[i].paint((DVBGraphics)dvbg);
	   //c[i].paint(g);
	   }
	**/
    }


	/** tejopa 4.3.2004 */
    protected void processWindowEvent(WindowEvent we) {
		Out.printMe(Out.TODO);
    	for (int i=0;i<windowListeners.size();i++) {
    		// TODO
    	}
    }

	/** tejopa 4.3.2004 */
    public void removeShortcut(int keyCode)    {
        Enumeration keys = shortcuts.keys();
        while (keys.hasMoreElements()) {
        	Integer key = (Integer)keys.nextElement();
        	if (key.intValue()==keyCode) {
        		shortcuts.remove(key);
        	}
        }
    }

	/** tejopa 4.3.2004 */
    public void removeWindowListener(WindowListener wl)    {
        windowListeners.remove(wl);
    }

	/** tejopa 4.3.2004 */
    public void setBackgroundImage(Image image)    {
        backgroundImage = image;
    }

	/** tejopa 4.3.2004 */
    public void setBackgroundMode(int mode)    {
        backgroundMode = mode;
    }

	/** tejopa 4.3.2004 */
    public boolean setRenderMode(int mode)    {
        if(mode == IMAGE_NONE || mode == IMAGE_STRETCH || mode == IMAGE_CENTER || mode == IMAGE_TILE) {
            renderMode = mode;
            return true;
        } else {
			Out.printMe(Out.ERROR,"render mode "+mode+" not supported");
            return false;
        }
    }

	/** tejopa 4.3.2004 */
    public void setVisible(boolean visible)    {
    	super.setVisible(visible);
    }


	/** tejopa 4.3.2004 */
    public void show()    {
        super.show();
    }



	/** tejopa 4.3.2004 */
	public void requestFocus() {
		setVisible(true);
		show();
		super.requestFocus();
	}


	// PRIVATE

	



    private int getComponentIndex(Component component)    {
        Component c[] = getComponents();
        for(int i = 0;i<c.length; i++) {
            if(c[i]==component) {
                // found
                return i;
            }
		}
		// not found
        return -1;
    }


	// HComponentOrdering

	/** tejopa */
    public Component addAfter(Component component, Component front)    {
        if (component == front) {
            return component;
        }

        if(getComponentIndex(component) != -1) {
            pushBehind(component, front);
            return component;
        }

        if(getComponentIndex(component) == -1)
        {
            add(component);
            pushBehind(component, front);
            return component;
        }
        else {
            // error
            return null;
        }
    }

	/** tejopa */
    public Component addBefore(Component component, Component behind)    {
        if(component == behind) {
            return component;
        }
        if(getComponentIndex(behind) == -1) {
            // behind was not added
            return null;
        }
        else {
            return add(component, getComponentIndex(behind));
    	}
    }

	/** tejopa */
    public boolean pop(Component component)    {
        int i = getComponentIndex(component);
        if ( (i-1) > -1 ) {
            add(component, i-1);
            return true;
        } else {
            return false;
        }
    }

	/** tejopa */
	public boolean popInFrontOf(Component move, Component behind)    {
        if(move == behind) {
            return true;
        }
        // check if both are added
        if(getComponentIndex(move) == -1 || getComponentIndex(behind) == -1) {
            return false;
        } else {
        	add(move, getComponentIndex(behind));
            return true;
        }
    }


	/** tejopa */
    public boolean popToFront(Component component)    {
        if (component!=null) {
	        add(component, 0);
        	return true;
        }
        else {
        	return false;
        }
    }

	/** tejopa */
    public boolean push(Component component)    {
        int i = getComponentIndex(component);
        if( (i+1) < getComponentCount()) {
            add(component, i+1);
            return true;
        } else {
            return false;
        }
    }

	/** tejopa */
    public boolean pushBehind(Component move, Component front)    {
		if (move==front) {
			return true;
		}
        // check if both are added
        if(getComponentIndex(move) == -1 || getComponentIndex(front) == -1) {
            return false;
        } else {
        	int i = getComponentIndex(front);
        	if ((i+1)<getComponents().length) {
	        	add(move, i+1);
            }
            return true;
        }
    }

	/** tejopa */
    public boolean pushToBack(Component component)    {
        int i = getComponentIndex(component);
        if(i != -1){
            add(component);
            return true;
        } else {
        	// was not added
            return false;
        }
    }





}
