package org.havi.ui;

import java.awt.Dimension;
import org.davic.resources.*;
import org.havi.ui.event.*;

import org.openmhp.util.LinkedList;
import org.openmhp.util.Out;

 /**
 * @author tejopa
 * @date 11.3.2004 
 * @status partially implemented
 * @module internal, video, graphics
 * @TODO map through adaptation layer: aspect ratio, id, reserving
 */
public class HScreenDevice implements ResourceProxy, ResourceServer {

	private LinkedList screenConfigurationListeners;
	private LinkedList resourceStatusListeners;
    private ResourceClient currentResourceClient = null;
    private HScreenConfigTemplate hScreenConfigTemplate;

    public HScreenDevice()    {    }

    public void addResourceStatusEventListener(ResourceStatusListener l) {
		if (resourceStatusListeners==null) {
			resourceStatusListeners = new LinkedList();
		}
		resourceStatusListeners.add(l);
    }

    public void addScreenConfigurationListener(HScreenConfigurationListener l) {
		if (screenConfigurationListeners==null) {
			screenConfigurationListeners = new LinkedList();	
		}
		screenConfigurationListeners.add(l);
    }

    public void addScreenConfigurationListener(HScreenConfigurationListener l, HScreenConfigTemplate hscreenconfigtemplate) {
        addScreenConfigurationListener(l);
   		Out.printMe(Out.TODO,"check template and create event if needed, add template to some structure");
        hScreenConfigTemplate = hscreenconfigtemplate;
    }

    public ResourceClient getClient() {
        return currentResourceClient;
    }

    public String getIDstring()    {
		Out.printMe(Out.TODO);
		return "this is not a unique HScreenDevice ID string";
	}

    public Dimension getScreenAspectRatio() {
		Out.printMe(Out.TODO);
        return new Dimension(720,576);
    }

    public void releaseDevice()    {
        if (resourceStatusListeners!=null) {
            HScreenDeviceReleasedEvent e = new HScreenDeviceReleasedEvent(currentResourceClient);
        	for (int i=0;i<resourceStatusListeners.size();i++) {
        		((ResourceStatusListener)resourceStatusListeners.get(i)).statusChanged(e);	
        	}
        }
        currentResourceClient = null;
    }

    public void removeResourceStatusEventListener(ResourceStatusListener l)     {
		if (resourceStatusListeners!=null) {
			resourceStatusListeners.remove(l);
		}
    }

    public void removeScreenConfigurationListener(HScreenConfigurationListener l) {
		if (screenConfigurationListeners!=null) {
			screenConfigurationListeners.remove(l);
		}

    }

    public boolean reserveDevice(ResourceClient client)    {
        currentResourceClient = client;
        if (resourceStatusListeners!=null) {
            HScreenDeviceReleasedEvent e = new HScreenDeviceReleasedEvent(currentResourceClient);
        	for (int i=0;i<resourceStatusListeners.size();i++) {
        		((ResourceStatusListener)resourceStatusListeners.get(i)).statusChanged(e);	
        	}
        }
    	return true;
    }

}