package org.havi.ui;

import java.awt.event.*;
import java.awt.*;
import org.havi.ui.event.*;

import org.openmhp.util.LinkedList;
import org.openmhp.util.Out;

/**
* @author tejopa
* @date 11.3.2004 
* @status partially implemented
* @module internal
* TODO process events, check default values
*/
public class HText extends HStaticText implements HNavigable { 

    private static HTextLook defaultHLook = new HTextLook();
    //private HLook hLook = defaultHLook;
    private HSound gainFocusSound;
    private HSound loseFocusSound;
    private HFocusListener focusListener;

	private LinkedList targets;
	private LinkedList keys;
	
    public HText(){
        super();
    }

    public HText(String text){
        super(text);
    }

    public HText(String text, String textFocus){
        this(text);
        setTextContent(textFocus, HVisible.NORMAL_STATE);
    }

    public HText(String text, int x, int y, int width, int height){
        super(text, x, y, width, height);
    }

    public HText(String text, String textFocus, int x, int y, int width, int height){
        super(text, x, y, width, height);
        this.setTextContent(text, HVisible.NORMAL_STATE);
    }

    public HText(String text, Font font, Color foreground, Color background, HTextLayoutManager tlm){
        super(text, font, foreground, background, tlm);
    }

    public HText(String textNormal, String textFocus, Font font, Color foreground, Color background, HTextLayoutManager tlm){
        super(textNormal, font, foreground, background, tlm);
        this.setTextContent(textFocus, HVisible.NORMAL_STATE);
    }

    public HText(String textNormal, int x, int y, int width, int height, Font font, Color foreground, Color background, HTextLayoutManager tlm){
        super(textNormal, x, y, width, height, font, foreground, background, tlm);
    }

    public HText(String textNormal, String textFocus, int x, int y, int width, int height, Font font, Color foreground, Color background, HTextLayoutManager tlm){
        super(textNormal, x, y, width, height, font, foreground, background, tlm);
        this.setTextContent(textFocus, HVisible.NORMAL_STATE);
    }

    public static void setDefaultLook(HTextLook defaultHLook){
        HText.defaultHLook = defaultHLook;
    }

    public static HTextLook getDefaultLook(){
        return HText.defaultHLook;
    }

    public void setMove(int keyCode, HNavigable target){
        if (keys==null) {
        	targets = new LinkedList();
        	keys   = new LinkedList();	
        }

        Integer newcode = new Integer(keyCode);
		int index = keys.indexOf(newcode);
		
		if (index!=-1) {
			keys.remove(keys.get(index));
			targets.remove(targets.get(index));
		}
		keys.add(newcode);
		targets.add(target);
    }

    public HNavigable getMove(int keyCode){
		int index = keys.indexOf(new Integer(keyCode));
		if (index!=-1) {
			return (HNavigable)targets.get(index);	
		}
		else {
			return null;	
		}
    }

    public void setFocusTraversal(HNavigable up, HNavigable down, HNavigable left, HNavigable right){
        setMove(KeyEvent.VK_UP, up);
        setMove(KeyEvent.VK_DOWN, down);
        setMove(KeyEvent.VK_LEFT, left);
        setMove(KeyEvent.VK_RIGHT, up);
    }

    public boolean isSelected(){
        return hasFocus();
    }

    public void setGainFocusSound(HSound sound){
        gainFocusSound = sound;
    }

    public void setLoseFocusSound(HSound sound){
        loseFocusSound = sound;
    }

    public HSound getGainFocusSound(){
        return gainFocusSound;
    }

    public HSound getLoseFocusSound(){
        return loseFocusSound;
    }

    public synchronized void addHFocusListener(HFocusListener listener){
        if (listener == null) {
            return;
        }
        focusListener = HEventMulticaster.add(focusListener, listener);
    }

    public synchronized void removeHFocusListener(HFocusListener listener) {
        if (listener == null) {
            return;
        }
        focusListener = HEventMulticaster.remove(focusListener, listener);
    }

    public int[] getNavigationKeys(){
		int[] result = null;
		if (keys!=null) {
			result = new int[keys.size()];
			for (int i=0;i<keys.size();i++) {
				result[i] = ((Integer)keys.get(i)).intValue();
			}
        }
		return result;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void processHFocusEvent(HFocusEvent evt) {
		Out.printMe(Out.TODO);
    }


}
