package org.openmhp.adaptation.event;

import org.openmhp.util.Out;
import org.havi.ui.event.*;
import java.awt.*;
import java.awt.event.*;
import org.havi.ui.event.HRcEvent;
/**
* This class creates instances for HEventRepresentation.
* @author tejopa
* @date 5.4.2004
* @TODO Remove not supported event ids.
* @TODO Symbols and colors are not supported
*/
public class HEventCapabilities {

	static HEventCapabilities instance = null;

	static int[] events = new int[]{
		HRcEvent.VK_GO_TO_START, HRcEvent.VK_REWIND, HRcEvent.VK_STOP,
		HRcEvent.VK_PAUSE, HRcEvent.VK_PLAY, HRcEvent.VK_FAST_FWD,
		HRcEvent.VK_GO_TO_END, HRcEvent.VK_TRACK_PREV, HRcEvent.VK_TRACK_NEXT,
		HRcEvent.VK_RECORD, HRcEvent.VK_EJECT_TOGGLE, HRcEvent.VK_VOLUME_UP,
		HRcEvent.VK_VOLUME_DOWN, KeyEvent.VK_UP, KeyEvent.VK_DOWN,
		KeyEvent.VK_LEFT, KeyEvent.VK_RIGHT, HRcEvent.VK_POWER
	};

	static String[] strings = new String[]{
		"Two equilateral triangles, pointing at a line to the left", "Two equilateral triangles, pointing to the left", "A square",
		"Two vertical lines, side by side", "One equilateral triangle, pointing to the right", "Two equilateral triangles, pointing to the right",
		"Two equilateral triangles, pointing to a line at the right", "One equilateral triangle, pointing to a line at the left", "One equilateral triangle, pointing to a line at the right",
		"A circle, normally red", "A line under a wide triangle which points up", "A ramp, increasing to the right, near a plus sign",
		"A ramp, increasing to the right, near a minus sign", "An arrow pointing up", "An arrow pointing down",
		"An arrow pointing to the left", "An arrow pointing to the right", "A circle, broken at the top, with a vertical line in the break"
	};

	static String[] symbolfiles = null;
	static Image[] symbols = null;

	protected HEventCapabilities() {	}

	public static HEventCapabilities getInstance() {
		if (instance==null) {
			instance = new HEventCapabilities();
		}
		return instance;
	}

	/**
	* Find correct event from supported events and initialize values for it.
	*/
	private static void init(HEventRepresentationImpl presentation) {
		int index = indexOf(presentation.getId());
		// set string
		presentation.setString(strings[index]);
		// set symbol
		presentation.setType(HEventRepresentation.ER_TYPE_STRING);		
	}

	/**
	* Returns index for given event code, returns -1 if event not found (not supported).
	*/
	private static int indexOf(int code) {
		int index = -1;
		for (int i=0;i<events.length;i++) {
			if (events[i]==code) {
				index = i;
			}
		}
		return index;
	}

	// called from HRcCapabilities

	/**
	* Remote control is always present.
	* @author tejopa
	* @date 5.4.2004
	*/
    public static boolean getInputDeviceSupported(){
		Out.printMe(Out.TRACE,"Remote control is available.");
		return true;
    }

	/**
	* Create representation only if supported.
	* @author tejopa
	* @date 5.4.2004
	*/
    public static HEventRepresentation getRepresentation(int aCode){
		if (isSupported(aCode)) {
			HEventRepresentationImpl eventr = new HEventRepresentationImpl(aCode);
			init(eventr);
			return (HEventRepresentation)eventr;
		}
		else {
			return null;	
		}
    }

	/**
	* If argument keycode can be found from supported events, return true, else return false.
	* @author tejopa
	* @date 5.4.2004
	*/
    public static boolean isSupported(int keycode){
		if (indexOf(keycode)!=-1) {
			return true;
		}
		else {
			return false;
		}
	}


	// called from HEventRepresentation

	/**
	* If HEventRepresentation has been created, it has to be supported.
	* @author tejopa
	* @date 5.4.2004
	*/
    public static boolean isSupported(HEventRepresentation presentation){
		return true;
	}

	// called from HKeyCapabilities

	public static boolean isKeyboardSupported() {
		Out.printMe(Out.TRACE,"Keyboard is not supported.");
		return false;
	}
}