package org.openmhp.adaptation.rc;

import org.davic.resources.*;
import java.io.IOException;
import org.dvb.net.rc.*;


import org.openmhp.util.*;

/**
* @author tejopa
* @date 15.9.2004
* @status partially implemented
* @module return channel
*/
public class CATVRCInterface extends ConnectionRCInterface implements ResourceProxy {

	ConnectionParameters parameters = null;
	ResourceClient currentClient = null;
	Object clientData = null;
	LinkedList listeners;

	public CATVRCInterface(){
		setType(RCInterface.TYPE_CATV);
		setDataRate(2048000);		
		listeners = new LinkedList();
	}

	public boolean isConnected(){
		Out.printMe(Out.TRACE,"CATV always connected");
		return true;
	}

	public float getSetupTimeEstimate()	{
		Out.printMe(Out.TRACE,"returns 0.0f");
		return 0.0f;
	}

	public void reserve(ResourceClient c, Object requestData) throws PermissionDeniedException{
		Out.printMe(Out.TRACE);
		currentClient = c;
		clientData = requestData;
		RCInterfaceReservedEvent e = new RCInterfaceReservedEvent(this);

	}

	public void release(){
		Out.printMe(Out.TRACE);
		RCInterfaceReleasedEvent e = new RCInterfaceReleasedEvent(this);
		currentClient = null;
		clientData = null;
	}

	public void connect() throws IOException, PermissionDeniedException{
		Out.printMe(Out.TRACE);
		ConnectionEstablishedEvent e = new ConnectionEstablishedEvent(this);
		for (int i=0;i<listeners.size();i++) {
			ConnectionListener l = (ConnectionListener)listeners.get(i);	
			l.connectionChanged(e);
		}
	}

	public void disconnect() throws PermissionDeniedException{
		Out.printMe(Out.TRACE);
		ConnectionTerminatedEvent e = new ConnectionTerminatedEvent(this);
		for (int i=0;i<listeners.size();i++) {
			ConnectionListener l = (ConnectionListener)listeners.get(i);	
			l.connectionChanged(e);
		}
	}

	public ConnectionParameters getCurrentTarget() throws IncompleteTargetException{
		Out.printMe(Out.TRACE);
		return parameters;
	}

	public void setTarget(ConnectionParameters target) throws IncompleteTargetException, PermissionDeniedException{
		Out.printMe(Out.TRACE);
		parameters = target;
	}

	public void setTargetToDefault() throws PermissionDeniedException{
		Out.printMe(Out.TRACE);
		parameters = new ConnectionParameters(null,null,null);
	}

	public int getConnectedTime(){
		Out.printMe(Out.TRACE,"0");
		return 0;
	}

	public ResourceClient getClient(){
		Out.printMe(Out.TRACE);
		return currentClient;
	}

	public void addConnectionListener(ConnectionListener l ){
		Out.printMe(Out.TRACE);
		listeners.add(l);
	}

	public void removeConnectionListener(ConnectionListener l ){
		Out.printMe(Out.TRACE);
		listeners.add(l);
	}

}


