package org.openmhp.adaptation.resources;

import java.net.URL;
import org.dvb.lang.DVBClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.FileNotFoundException;

import org.openmhp.util.Out;

/*
* This class is not tested. The classloader itself works, but it is not tested
* in the MHP environment.
*
* @author tejopa
* @date 10.2.2004
*/
public class DVBClassLoaderImpl extends DVBClassLoader {
	
	public DVBClassLoaderImpl(URL[] urls){ 
		super(urls);
	}

    public DVBClassLoaderImpl(URL[] urls, ClassLoader parent){
		super(urls,parent);
    }

	/**
	* Method tries to find a class with given name from the allowed URLs.
	*/
    public Class findClass(String name) throws ClassNotFoundException {
		return loadClass(name,true);
    }

	/**
	* Method tries to load bytes from the file with given name. File is searched
	* from the allowed URLs. If the file could not be found, a ClassNotFoundException is thrown.
	*/
	protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
		System.out.println("<MHP RE> [DVBClassLoaderImpl loading class]: "+name);
		Class class_to_load = null;
		// check if already loaded
		class_to_load = findLoadedClass(name);
		// class was found, return it
		if (class_to_load!=null) {
			System.out.println("[found from loaded class]");
			return class_to_load;
		}
		else {
			//System.out.println("not found from loadedClasses");	
		}
		// this is reached only if class was not found 
		try {
			URL url = null;
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			for (int i=0;i<searchPaths.length;i++) {
				// if class is found, do not enter try
				if (class_to_load==null) {
					String filename = name;
					filename = filename.replace('.','/');
					url = searchPaths[i];
					filename = url.toString()+filename+".class";
					//System.out.println(filename);
					url = new URL(filename);
					try {
						InputStream is = url.openStream();
						// collect bytes to vector
						int b = -1;
						while ( (b = is.read()) != -1 ) { baos.write(b); }
						is.close();
						
						// create bytearray
						byte[] byte_array = baos.toByteArray();

						// try to define bytearray as a class
						class_to_load = defineClass(name, byte_array, 0, byte_array.length);
					}
					catch (FileNotFoundException u) {
						//System.out.println("class "+name+" not found from urls.");
						}
					catch (Exception u2) {
						System.out.println(u2);
					}
				} // if
			}
		}
		catch (Exception e) { System.out.println(e); }

		if (class_to_load==null) {
			try {
				class_to_load = findSystemClass(name);
			}
			catch (Exception e) { 
			//	System.out.println("not in system");
			}
			//if (class_to_load!=null) System.out.println("Found class "+name+" from system!");
		}

		// Class does not exist in the search path
		if (class_to_load==null) { 
			Out.error(this,"could not find class "+name);	
			throw new ClassNotFoundException("Class "+name+" was not found from given urls or system.");
		}

		// try to resolve class, if needed
		if ((class_to_load!=null)&&(resolve)) {
			resolveClass(class_to_load);
		}

		return class_to_load;
	}

}
