package org.openmhp.appman;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;
import org.dvb.application.*;
import javax.tv.locator.*;

import org.openmhp.system.*;

/**
 * @date 10.12.2004 Added classpath check // tejopa
 */
public class Appman extends JFrame implements ActionListener, ListSelectionListener, MouseListener {

    private JTabbedPane tabbedPane;
    private JList applicationList;
    private JTable applicationTable;

    ProjectData projectData;

    private int currentIndex = 0;
    private Project currentProject = null;
    private static Project[] currentProjects = null;
    private JPanel currentTab;
    private JPopupMenu popupmenu;
    private JMenuItem add;
    private JMenuItem start;
    private JMenuItem remove;
    private ProjectHandler projectHandler;

    JScrollPane scrollpane;

    private JMenuBar menuBar;
    private JMenu fileMenu;

    JTextField[] fields;
    JCheckBox[] checkboxes;
    JCheckBox subtitles_cb;

    public final static int PROJECT_NAME = 0;
    public final static int CLASSPATH = 1;
    public final static int XLETNAME = 2;
    public final static int ORGID = 3;
    public final static int APPID = 4;

    public final static int CLASSLOADER = 0;
    public final static int TRACE = 1;
    public final static int DEBUG = 2;
    public final static int TODO = 3;
    public final static int FIXME = 4;
    public final static int ERROR = 5;

    private Configuration configuration;

    public Appman() {
        main();
    }

    private void main() {

        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE );

        applicationList = new JList();
        applicationList.addMouseListener(this);
        applicationList.addListSelectionListener(this);

        projectData = new ProjectData(new String[]{"Application","App id","Org id","Status"});
        applicationTable = new JTable(projectData);
        applicationTable.addMouseListener(this);
        applicationTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        //applicationTable.addListSelectionListener((ListSelectionListener)this);

        addMouseListener(this);

        /* tejopa 4.4.2005 */
        projectHandler = new ProjectHandler(System.getProperty("base_dir")+File.separator+System.getProperty("project_dir"));//org.openmhp.system.Constants.PROJECT_DIR);

        updateProjects();

        //		JScrollPane scrollpane = new JScrollPane(applicationList);

        scrollpane = new JScrollPane(applicationTable);
        scrollpane.addMouseListener(this);

        tabbedPane = new JTabbedPane();
        tabbedPane.add("Applications",scrollpane);

        getContentPane().add(tabbedPane);

        popupmenu = new JPopupMenu();

        add = new JMenuItem("Add");
        add.addActionListener(this);
        add.setActionCommand("add");
        popupmenu.add(add);

        start = new JMenuItem("Start");
        start.addActionListener(this);
        start.setActionCommand("start");
        popupmenu.add(start);

        remove = new JMenuItem("Remove");
        remove.addActionListener(this);
        remove.setActionCommand("remove");
        popupmenu.add(remove);

        menuBar = new JMenuBar();

        fileMenu = new JMenu("File");
        menuBar.add(fileMenu);

        JMenuItem config = new JMenuItem("Configure");
        config.addActionListener(this);
        config.setActionCommand("configure");
        fileMenu.add(config);

        JMenuItem exit = new JMenuItem("Exit");
        exit.addActionListener(this);
        exit.setActionCommand("exit");
        fileMenu.add(exit);

        setJMenuBar(menuBar);

        //AppsDatabaseImpl.getInstance().addListener(this);

        setTitle("OpenMHP 1.0 - Application Manager");
        setSize(500, 400);
        setVisible(true);

        /* tejopa 10.12.2004 */
        String FS = File.separator;
        //Properties p = Configuration.loadProperties(System.getProperty("base_dir")+"static"+FS+"openmhp.properties");
        String javatv_path = System.getProperty("javatv_jar","");
        if (javatv_path.length()<1) {
            JOptionPane.showMessageDialog(this, "Choose paths to JavaTV jar (javatv.jar)\nand Java Media Framework jar (jmf.jar)");
            configure();
            configuration.setSelectedIndex(2);
        }
        setListeners();
    }

    private void setListeners() {
        AppsDatabase appsdatabase = AppsDatabase.getAppsDatabase();
        if(appsdatabase != null) {
            Enumeration enumeration = appsdatabase.getAppAttributes(new CurrentServiceFilter());
            if(enumeration != null) {
                int i = 0;
                while(enumeration.hasMoreElements())  {
                    AppAttributes appattributes = (AppAttributes)enumeration.nextElement();
                    AppProxy appproxy = appsdatabase.getAppProxy(appattributes.getIdentifier());
                    //appproxy.addAppStateChangeEventListener(this);
                    AppID appid = appattributes.getIdentifier();
                    int k = appproxy.getState();
                    String s = "unknown";
                    switch(k) {
                        case 1: // '\001'
                            s = "destroyed";
                            break;

                        case 2: // '\002'
                            s = "not loaded";
                            break;

                        case 3: // '\003'
                            s = "paused";
                            break;

                        case 0: // '\0'
                            s = "started";
                            break;
                    }
                    String s1 = "";
                    s1 = s1 + appattributes.getName();
                    s1 = s1 + " OID: " + appid.getOID() + " AID: " + appid.getAID();
                    s1 = s1 + " " + s;
                    System.out.println("-----------------------------");
                    System.out.println(s1);
                    i++;
                    String as[] = (String[])appattributes.getProperty("javax.tv.xlet.args");
                    if(as != null) {
                        for(int l = 0; l < as.length; l++)
                            System.out.println("[" + l + "]:" + as[l]);

                    }
                }
                System.out.println("-----------------------------");
            }
        }
    }

    private Project[] getProjects() {
        Project[] projectArray = projectHandler.getProjects();
        return projectArray;
    }

    private Project[] getCurrentProjects() {
        return currentProjects;
    }

    private void updateProjects()    {
        currentProjects = getProjects();
        //String p[] = new String[currentProjects.length];
        projectData.removeRows();

        for(int i = 0; i < currentProjects.length; i++) {
            //p[i] = currentProjects[i].getProjectName();
            Vector line = new Vector();
            line.add(currentProjects[i].getProjectName());
            line.add(currentProjects[i].getAppId());
            line.add(currentProjects[i].getOrgId());
            line.add(currentProjects[i].getOrgId());
            projectData.addRow(line);
        }
        //applicationList.setListData(p);
        applicationTable.updateUI();
    }


    private void launchCurrent() {

        if (currentProject!=null)	{
            System.out.println("launching...");
            new org.openmhp.system.Shell(new String[]{ currentProject.getPath(),currentProject.getXletClass(), currentProject.getOrgId(), currentProject.getAppId()});

            try { Thread.currentThread().sleep(1000); } catch (Exception r) { }
            Exception e = org.openmhp.system.Shell.getException();
            if (e!=null) {
                JOptionPane.showMessageDialog(this, "Project "+currentProject.getProjectName()+" could not be started. Reason: \n"+e);
            }
        }
    }




    public void valueChanged(ListSelectionEvent event) {
        boolean adjusting = false;
        if(event.getValueIsAdjusting()) {
            adjusting = true;
        }

        if(applicationList.isSelectionEmpty()) {
            currentProject = null;
        } else {
            if (!adjusting) {
                //currentIndex = applicationList.getSelectedIndex();
                currentIndex = applicationTable.getSelectedRow();

                createNewTab(false);
            }
        }
        System.out.println(event);
    }

    private void createNewTab(boolean empty) {
        tabbedPane.remove(currentTab);


        int l = 5;
        Box layout = new Box(BoxLayout.Y_AXIS);
        Box[] lines = new Box[l];

        /* create lines */

        fields = new JTextField[l];
        JButton[] buttons = new JButton[l];
        JLabel[] labels = new JLabel[l];

        labels[PROJECT_NAME] = new JLabel("Project name ",JLabel.RIGHT);
        labels[CLASSPATH] = new JLabel("Classpath ",JLabel.RIGHT);
        labels[XLETNAME] = new JLabel("Xlet ",JLabel.RIGHT);
        labels[ORGID] = new JLabel("Org ID ",JLabel.RIGHT);
        labels[APPID] = new JLabel("App ID ",JLabel.RIGHT);

        labels[PROJECT_NAME].setPreferredSize(new Dimension(80, 24));
        labels[CLASSPATH].setPreferredSize(new Dimension(80, 24));
        labels[XLETNAME].setPreferredSize(new Dimension(80, 24));
        labels[ORGID].setPreferredSize(new Dimension(80, 24));
        labels[APPID].setPreferredSize(new Dimension(80, 24));

        buttons[PROJECT_NAME] = new JButton("      ");
        buttons[CLASSPATH] = new JButton("Browse");
        buttons[XLETNAME] = new JButton("Browse");
        buttons[ORGID] = new JButton("      ");
        buttons[APPID] = new JButton("      ");

        fields[CLASSPATH] = new JTextField(25);
        fields[PROJECT_NAME] = new JTextField(25);
        fields[CLASSPATH] = new JTextField(25);
        fields[XLETNAME] = new JTextField(25);
        fields[ORGID] = new JTextField(25);
        fields[APPID] = new JTextField(25);

        lines[PROJECT_NAME] = new Box(BoxLayout.X_AXIS);
        lines[PROJECT_NAME].add(labels[PROJECT_NAME]);
        lines[PROJECT_NAME].add(fields[PROJECT_NAME]);

        lines[XLETNAME] = new Box(BoxLayout.X_AXIS);
        lines[XLETNAME].add(labels[XLETNAME]);
        lines[XLETNAME].add(fields[XLETNAME]);
        lines[XLETNAME].add(buttons[XLETNAME]);

        lines[CLASSPATH] = new Box(BoxLayout.X_AXIS);
        lines[CLASSPATH].add(labels[CLASSPATH]);
        lines[CLASSPATH].add(fields[CLASSPATH]);
        lines[CLASSPATH].add(buttons[CLASSPATH]);

        lines[ORGID] = new Box(BoxLayout.X_AXIS);
        lines[ORGID].add(labels[ORGID]);
        lines[ORGID].add(fields[ORGID]);

        lines[APPID] = new Box(BoxLayout.X_AXIS);
        lines[APPID].add(labels[APPID]);
        lines[APPID].add(fields[APPID]);

        buttons[CLASSPATH].setActionCommand("classpath");
        buttons[CLASSPATH].addActionListener(this);
        buttons[XLETNAME].setActionCommand("xletname");
        buttons[XLETNAME].addActionListener(this);


        /* create checkboxes */
        int c = 6;
        Box clayout = new Box(BoxLayout.Y_AXIS);
        Box[] clines = new Box[c];

        JPanel grid = new JPanel(new GridLayout(2,3));

        checkboxes = new JCheckBox[c];
        JLabel[] boxlabels = new JLabel[c];

        checkboxes[CLASSLOADER] = new JCheckBox();
        checkboxes[TRACE] = new JCheckBox();
        checkboxes[DEBUG] = new JCheckBox();
        checkboxes[TODO] = new JCheckBox();
        checkboxes[FIXME] = new JCheckBox();
        checkboxes[ERROR] = new JCheckBox();

        boxlabels[CLASSLOADER] = new JLabel("Classloader info ",JLabel.RIGHT);
        boxlabels[TRACE] = new JLabel("Trace messages ",JLabel.RIGHT);
        boxlabels[DEBUG] = new JLabel("Debug messages ",JLabel.RIGHT);
        boxlabels[TODO] = new JLabel("Todo messages",JLabel.RIGHT);
        boxlabels[FIXME] = new JLabel("Fixme messages ",JLabel.RIGHT);
        boxlabels[ERROR] = new JLabel("Error messages ",JLabel.RIGHT);

        clines[CLASSLOADER] = new Box(BoxLayout.X_AXIS);
        clines[CLASSLOADER].add(boxlabels[CLASSLOADER]);
        clines[CLASSLOADER].add(checkboxes[CLASSLOADER]);

        clines[TRACE] = new Box(BoxLayout.X_AXIS);
        clines[TRACE].add(boxlabels[TRACE]);
        clines[TRACE].add(checkboxes[TRACE]);

        clines[DEBUG] = new Box(BoxLayout.X_AXIS);
        clines[DEBUG].add(boxlabels[DEBUG]);
        clines[DEBUG].add(checkboxes[DEBUG]);

        clines[TODO] = new Box(BoxLayout.X_AXIS);
        clines[TODO].add(boxlabels[TODO]);
        clines[TODO].add(checkboxes[TODO]);

        clines[FIXME] = new Box(BoxLayout.X_AXIS);
        clines[FIXME].add(boxlabels[FIXME]);
        clines[FIXME].add(checkboxes[FIXME]);

        clines[ERROR] = new Box(BoxLayout.X_AXIS);
        clines[ERROR].add(boxlabels[ERROR]);
        clines[ERROR].add(checkboxes[ERROR]);

        /* create save and cancel */
        Box buttons2 = new Box(BoxLayout.X_AXIS);
        JButton save = new JButton("Save changes");
        save.setActionCommand("save");
        save.addActionListener(this);
        JButton reload = new JButton("Reload values");
        reload.setActionCommand("reload");
        reload.addActionListener(this);
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("cancel");
        cancel.addActionListener(this);

        buttons2.add(new Box.Filler(new Dimension(0,25), new Dimension(170,25), new Dimension(getWidth(),25)));

        buttons2.add(cancel);
        buttons2.add(save);
        buttons2.add(reload);


        for (int i=0;i<l;i++) {
            layout.add(lines[i]);
        }
        for (int i=0;i<c;i++) {
            grid.add(clines[i]);
        }


        /* subtitles */
        Box subtitles = new Box(BoxLayout.X_AXIS);
        subtitles_cb = new JCheckBox();
        JLabel sublabel = new JLabel("Subtitles on / off",JLabel.RIGHT);
        subtitles.add(sublabel);
        subtitles.add(subtitles_cb);
        subtitles.add(new Box.Filler(new Dimension(0,25), new Dimension(170,25), new Dimension(getWidth(),25)));



        layout.add(new JSeparator());
        layout.add(grid);
        layout.add(new JSeparator());
        layout.add(subtitles);
        layout.add(new JSeparator());
        layout.add(buttons2);


        currentTab = new JPanel();
        //currentTab.setName(currentProject.getProjectName());

        if(!empty) {
            //currentProject = getCurrentProjects()[currentIndex];
            updateProperties(currentProject);
            tabbedPane.add(currentTab,currentProject.getProjectName()+" properties");
        } else {
            reload.setEnabled(false);
            updateProperties(null);
            tabbedPane.add(currentTab,"<empty> properties");
        }

        currentTab.add(layout);

    }

    private void updateProperties(Project p) {
        if(p != null){
            fields[PROJECT_NAME].setText(p.getProjectName());
            fields[CLASSPATH].setText(p.getPath());
            fields[XLETNAME].setText(p.getXletClass());
            fields[ORGID].setText(p.getOrgId());
            fields[APPID].setText(p.getAppId());
            checkboxes[CLASSLOADER].setSelected(p.classloader);
            checkboxes[TRACE].setSelected(p.trace);
            checkboxes[DEBUG].setSelected(p.debug);
            checkboxes[TODO].setSelected(p.todo);
            checkboxes[FIXME].setSelected(p.fixme);
            checkboxes[ERROR].setSelected(p.error);
            subtitles_cb.setSelected(p.subtitles);

        } else {
            fields[ORGID].setText("0");
            fields[APPID].setText("0");
            checkboxes[CLASSLOADER].setSelected(true);
            checkboxes[TRACE].setSelected(true);
            checkboxes[DEBUG].setSelected(true);
            checkboxes[TODO].setSelected(true);
            checkboxes[FIXME].setSelected(true);
            checkboxes[ERROR].setSelected(true);
            subtitles_cb.setSelected(false);
        }
    }

    public void actionPerformed(ActionEvent event)   {
        String cmd = event.getActionCommand();
        if (cmd == "start") {
            if (currentProject!=null) {
                launchCurrent();
            } else {
                JOptionPane.showMessageDialog(this, "No project selected.");
            }
        }

        if (cmd == "remove") {
            if (currentProject!=null) {
                int i = JOptionPane.showConfirmDialog(this, "Remove permanently\n" + currentProject.getProjectName()+"\n", "Remove", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
                if(i == 0)         {
                    boolean removed = projectHandler.deleteProject(currentProject);
                    //updateProjects();
                    tabbedPane.remove(currentTab);
                    if (!removed) {
                        JOptionPane.showMessageDialog(this, "Project could not be removed.\nRestart and try to remove it again.");
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this, "No project selected.");
            }
            updateProjects();
            applicationTable.setRowSelectionInterval(0, 0);
        }
        if (cmd=="save") {

            String mustFill = "You have to fill in following fields";
            boolean fillError = false;
            if (fields[PROJECT_NAME].getText().length()<1) {
                mustFill+="\n- Project name";
                fillError = true;
            }
            if (fields[CLASSPATH].getText().length()<1) {
                mustFill+="\n- Classpath";
                fillError = true;
            }
            if (fields[XLETNAME].getText().length()<1) {
                mustFill+="\n- Xlet";
                fillError = true;
            }
            if (fields[ORGID].getText().length()<1) {
                mustFill+="\n- Org ID";
                fillError = true;
            }
            if (fields[APPID].getText().length()<1) {
                mustFill+="\n- App ID";
                fillError = true;
            }
            if (fillError) {
                JOptionPane.showMessageDialog(this, mustFill);
                return;
            }

            int tempIndex = currentIndex;

            Project temp = new Project();

            temp.projectName = fields[PROJECT_NAME].getText();
            temp.xletClass = fields[XLETNAME].getText();
            temp.path = fields[CLASSPATH].getText();
            temp.orgid = fields[ORGID].getText();
            temp.appid = fields[APPID].getText();

            temp.classloader = checkboxes[CLASSLOADER].isSelected();
            temp.todo = checkboxes[TODO].isSelected();
            temp.debug = checkboxes[DEBUG].isSelected();
            temp.fixme = checkboxes[FIXME].isSelected();
            temp.error = checkboxes[ERROR].isSelected();
            temp.trace = checkboxes[TRACE].isSelected();

            temp.subtitles = subtitles_cb.isSelected();

            currentProject = temp;

/*
                        currentProject.projectName = fields[PROJECT_NAME].getText();
            currentProject.xletClass = fields[XLETNAME].getText();
            currentProject.path = fields[CLASSPATH].getText();
            currentProject.orgid = fields[ORGID].getText();
            currentProject.appid = fields[APPID].getText();

            currentProject.classloader = checkboxes[CLASSLOADER].isSelected();
            currentProject.todo = checkboxes[TODO].isSelected();
            currentProject.debug = checkboxes[DEBUG].isSelected();
            currentProject.fixme = checkboxes[FIXME].isSelected();
            currentProject.error = checkboxes[ERROR].isSelected();
            currentProject.trace = checkboxes[TRACE].isSelected();
 */
            projectHandler.addProject(temp);

            updateProjects();

            String name = temp.getProjectName();
            JOptionPane.showMessageDialog(this, name+" properties saved.");

            int j=-1;
            for (int i=0;i<currentProjects.length;i++) {
                if (temp.getProjectName().equals(currentProjects[i].getProjectName())) {
                    j = i;
                }
            }

            if (j==-1) {
                currentIndex = tempIndex;
            } else {
                currentIndex = j;
            }
            currentProject = currentProjects[currentIndex];
            //applicationList.setSelectedIndex(currentIndex);
            applicationTable.setRowSelectionInterval(currentIndex, currentIndex);
            tabbedPane.setSelectedIndex(0);
            createNewTab(false);
        }

        if (cmd=="reload") {
            updateProperties(currentProject);
            JOptionPane.showMessageDialog(this, currentProject.getProjectName()+" properties loaded.");
        }

        if (cmd=="cancel") {
            tabbedPane.setSelectedIndex(0);
            tabbedPane.remove(currentTab);
        }

        if (cmd=="add") {
            createNewTab(true);
            tabbedPane.setSelectedIndex(1);
        }

        if (cmd=="classpath") {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
            try {
                fc.setCurrentDirectory(new File(fields[CLASSPATH].getText()));
            } catch (Exception e) { }
            int returnVal = fc.showOpenDialog(this);
            File file = fc.getSelectedFile();
            if (file!=null) {
                fields[CLASSPATH].setText(file.getAbsolutePath());
            }
        }

        if (cmd=="xletname") {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
            fc.setFileFilter((javax.swing.filechooser.FileFilter)new ClassFilter());
            try {
                fc.setCurrentDirectory(new File(fields[CLASSPATH].getText()));
            } catch (Exception e) { }
            int returnVal = fc.showOpenDialog(this);
            File file = fc.getSelectedFile();
            if (file!=null) {
                try {
                    String classfile = file.getAbsolutePath();
                    classfile = classfile.substring(fields[CLASSPATH].getText().length()+1,classfile.length());
                    classfile = classfile.replace(File.separatorChar,'.');
                    classfile = classfile.replaceFirst(".class","");
                    fields[XLETNAME].setText(classfile);
                } catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
        if (cmd=="exit") { System.exit(0); }
        if (cmd=="configure") { configure(); }
    }


    public void mouseClicked(MouseEvent e) {
        int clicks = e.getClickCount();

        //System.out.println(e);

        if (e.getButton()!=MouseEvent.BUTTON3) {
            int si = applicationTable.getSelectedRow();
            if (si!=-1) {
                currentProject = currentProjects[si];
                System.out.println(currentProject.getProjectName());
                createNewTab(false);
            }
        }

        if (clicks==2) {
            launchCurrent();
        }
        if (e.getButton()==MouseEvent.BUTTON3) {
            popupmenu.show(this, e.getX(), e.getY()+popupmenu.getHeight());

        }
    }

    public void mouseEntered(MouseEvent e) { }
    public void mouseExited(MouseEvent e) { }
    public void mousePressed(MouseEvent e) { }
    public void mouseReleased(MouseEvent e) { }

    class ClassFilter extends javax.swing.filechooser.FileFilter {

        public ClassFilter() { }

        public boolean accept(File f) {
            if (f.getName().indexOf(".class")!=-1) {
                return true;
            }
            if (f.isDirectory()) {
                return true;
            } else {
                return false;
            }
        }

        public String getDescription() {
            return "Java class files";
        }

    }

    private void configure() {
        if (configuration==null) {
            configuration = new Configuration();
        } else {
            configuration.setVisible(true);
        }
    }
}
